function  [Ablack,Abare,Awhite,Temission,Trock,Tblack,Twhite,Ap,Tsun] = daisyworldc(Ablack,Awhite,transfer,carb,carbav,range,black,bare,white,S,q,death,startarea,lowgrowthK,highgrowthK,const)

SB = 5.669*10^-8; % Sets the Stefan-Boltzman constant
% Calculate the area of bare ground 
Abare = 1-Ablack-Awhite;

% Calculates the average planetary albedo 
Ap = Abare*bare + Awhite*white + Ablack*black;

% Calculates carbon dioxide's effect of temp 
Tcarb = (range/carb)*carbav-range/2;

% Calculates average emission temperature according to Ap 
Tsun = ((S/SB)*(1-Ap))^0.25; 
Temission = transfer + Tsun + Tcarb;

% Temperature of lifeless 'rock' for comparison 
Trock = ((S/SB)*(1-bare))^0.25;

% Local temperature around each coloured daisies 
Tblack = q*(Ap-black) + Temission; 
Twhite = q*(Ap-white) + Temission;

% Calculate CO2 growth restriction 
gres = 1-exp(-const*carbav);
% Calculate each daisy's growthrate according to temperature 
betab = beta(lowgrowthK,highgrowthK,Tblack); 
growthb = Ablack*(gres*betab*Abare-death); 
betaw = beta(lowgrowthK,highgrowthK,Twhite); 
growthw = Awhite*(gres*betaw*Abare-death);

% Calculate areas of daisies 
Ablack = Ablack + growthb; 
Awhite = Awhite + growthw;

% Check for no negative/excess area 
if Ablack <= startarea
   Ablack = startarea; 
end
if Ablack > 1 
   Ablack = 1;
end
if Awhite <= startarea
   Awhite = startarea; 
end
if Awhite > 1 
   Awhite = 1;
end
