function daisyvapour1(lower,upper)
global Ablack Awhite Abare Tblack Twhite Ap;

% Initialise arguments for function daisyworld 
S = 1000; %sets the current solar luminosity 
startarea = 0.01;
q = 20;
death = 0.1; 
lowgrowthK   = 278; 
highgrowthK  = 313; 
black        = 0.25; 
bare         = 0.5; 
white        = .75; 
latdiv       = 179; 
heatcon      = .75; 
outgoingheat = .9; 
LoverRT      = 20; 
intense      =  1; 
numba        = 100;

% Calculate number of time steps (numba per 3 billion years) 
length = (upper-lower)*numba;
jump   = (upper*S-lower*S)/(length-1);
E(1,1) = lower*S; % Initialises the lower limit relative to todays insolation 

for y = 2:length
    E(y,1) = E(y-1,1) + jump; % Creates the column matrix of increasing solar Energy
end
inc = 180/latdiv; 
lat = [(0+inc):inc:(180-inc)]; % Creates lat, column of latitude degrees
SB = 5.669*10^-8; % Sets the Stefan-Boltzman constant

[c,d] = size(lat); 
humidity = 20*ones(d,length); 
AB = startarea*ones(d,1); 
AW = startarea*ones(d,1); 
AP = zeros(d,1); 
transfer = zeros(d,1);

% Start loop for each time increment 
for a = 2:length+1
    Ecurrent=E(a-1,1); 
    for b = 1:d
	S = dsin(lat(1,b))*Ecurrent; % Defines the energy received at each latitude
        % Call function and store results
	[Ablackresults(b,a-1),Abareresults(b,a-1),Awhiteresults(b,a-1),Temissionresults(b,a- 1),Trockresults(b,a-1),Tblackresults(b,a-1),Twhiteresults(b,a-1),Apresults(b,a-1),Tsun(b,a- 1)]=daisyworldb(AB(b,1),AW(b,1),transfer(b,1),black,bare,white,S,q,death,startarea,lowgro wthK,highgrowthK);
        AB(b,1) = Ablackresults(b,a-1); 
        AW(b,1) = Awhiteresults(b,a-1); 
        AP(b,1) = Apresults(b,a-1);
    end

    % Heat transfer across latitudes from equator & vapour statement
    humidity((round(d)/2),a)=100*exp(.1*((Temissionresults(round(d/2),a-1))-308)); %ensure not too large
    if humidity((round(d)/2),a)>100
       humidity((round(d)/2),a)=100; 
    end
    if humidity((round(d)/2),a)<1 
       humidity((round(d)/2),a)=1;
    end
    %transfers heat and gives water vapour feedback 
    for f = ((round(d/2)+1)):d
        heatmove=heatcon*(1-(round(d)/2)*exp(-(1/q)*f))*(Temissionresults(f-1,a-1)- Temissionresults(f,a-1));
    if heatmove<.01 
       heatmove=.01;
    end
    if heatmove>6
       heatmove=6; 
    end
    Temissionresults(f,a-1) = Temissionresults(f,a-1) + heatmove;
    
    % Vapour statement 
    dhumidity = -LoverRT*((Temissionresults(f-1,a-1)-Temissionresults(f,a-1)));
    
    humidity(f,a-1)=humidity(f-1,a-1)+dhumidity; 
    
    if humidity(f,a-1)>100
       humidity(f,a-1)=100; 
    end
    if humidity(f,a-1)<1 
       humidity(f,a-1)=1;
    end
    if dhumidity<-20
       dhumidity=-20; 
    end
    if dhumidity>=0 
       dhumidity=-0.01;
    end
    % Feedback to temperature 
    dT = intense*Temissionresults(f,a-1)*(dhumidity/humidity(f,a-1))*((LoverRT)^-1); 
    
    if dT>1
       dT=1; 
    end
    if dT<-1 
       dT=-1;
    end 
    Temissionresults(f,a-1) = Temissionresults(f,a-1)+dT;
    
    % Mirror image 
    Temissionresults((d-f+1),a-1) = Temissionresults(f,a-1); 
    humidity(d-f+1,a-1) = humidity(f,a-1);
    end
    
    % Stores the heat information for the next time step 
    transfer(:,1) = outgoingheat*(Temissionresults(:,a-1)-Tsun(:,a-1));
end

% Figures
[g,h]=size(lat);

% Plot the results
figure(1) 
surf(1:length,1:h,Temissionresults) 
xlabel('Time')
ylabel('Latitude') 
zlabel('Temperature (K)') 
shading interp;

figure(2)
subplot(2,1,1) 
pcolor(1:length,1:h,Apresults) 
shading interp; colormap(gray); 
title('Greyscale map of albedo') 
xlabel('Time') 
ylabel('Latitude')
hold on;

subplot(2,1,2)
plot(1:length,mean(Apresults)) 
xlabel('Time')
ylabel('Mean planetary albedo') 

figure(3)
subplot(3,1,1)
surf((1:length),1:h,Ablackresults)
shading interp;
text(3,latdiv,0.9,'Black daisy area')
hold on;
xlabel('Time')
ylabel('Latitude')
subplot(3,1,2)
surf((1:length),1:h,Awhiteresults)
shading interp;
hold on;
text(3,latdiv,0.9,'White daisy area') 
xlabel('Time')
ylabel('Latitude')
subplot(3,1,3) surf((1:length),1:h,Awhiteresults+Ablackresults) 
shading interp;
text(3,latdiv,0.9,'Total daisy area') 
xlabel('Time')
ylabel('Latitude')

figure(4)
[j,k]=size(humidity);
surf(1:k,1:j,humidity)
shading interp;
xlabel('Time')
ylabel('Latitude')
zlabel('Humidity')
