/*
 * -----------------------------------------------------------------------------
 * "THE BEER-WARE LICENSE" (Revision 42):
 * <nlehmann@dcc.uchile.cl> wrote this file. As long as you retain this notice
 * you can do whatever you want with this stuff. If we meet some day, and you
 * think this stuff is worth it, you can buy me a beer in return Nicolás Lehmann
 * -----------------------------------------------------------------------------
 */

#include <iostream>
#include <vector>
using namespace std;

// Este programa hace lo mismo que el anterior pero con una salvedad.
// Por motivos de eficiencia no es recomendable pasar un vector como parametro
// a una función pues si se hace esto entonces todos los valores del vector
// seran compiados.
// Para evitar esto cuando pasamos vectores como parametros es recomendable
// usar la siguiente declaracion "const vector<int> &vec", de esta forma
// estamos indicando que el vector se pasa como "referencia". Además
// especificamos que el vector es constante (const) y no puede ser modificado
// dentor de la función.
// Pueden averiguar más respecto a pasar parametros por valor o referencia, o
// aceptar esto como una regla.
int sum_vec(const vector<int> &vec) {
  int sum = 0;
  for (int i = 0; i < vec.size(); ++i) {
    sum += vec[i];
  }

  return sum;
}

#include <iostream>
#include <vector>

int main() {
  int n;
  cin >> n;
  vector<int> my_vec(n);
  for (int i = 0; i < n; ++i) {
    int a;
    cin >> a;
    my_vec[i] = a;
  }

  int s = sum_vec(my_vec);

  cout << s << endl;
  return 0;
}

