/*
 * -----------------------------------------------------------------------------
 * "THE BEER-WARE LICENSE" (Revision 42):
 * <nlehmann@dcc.uchile.cl> wrote this file. As long as you retain this notice
 * you can do whatever you want with this stuff. If we meet some day, and you
 * think this stuff is worth it, you can buy me a beer in return Nicolás Lehmann
 * -----------------------------------------------------------------------------
 */

#include <iostream>
#include <vector>
using namespace std;


// Algo interesante de los vectores es que si no se conoce el largo que deben
// tener a priori podemos ir aumentando de a poco este largo agregando valores
// al final. El siguiente código hace lo mismo que el del archivo anterior pero
// inializando el vector con largo 0.


int main () {
  int n;
  cin >> n;

  // Si no pasamos nada a vec este se crea de tamaño cero, esto es equivalente
  // a escribir vector<int> vec(0);
  // Ojo que no es lo mismo escribir vector<int> vec(), la diferencia es sútil
  // y bien específica.
  vector<int> vec;

  for (int i = 0; i < n; i++) {
    int a;
    cin >> a;
    // Ahora no podemos acceder a la posición i pues el vector no tiene el
    // largo adecuado. Acceder a una posición mayor que el largo del vector
    // es un error, pero cuidado porque uno se dará cuenta de esto sólo cuando
    // el código es ejecutado. Y lo peor es que en C++, puede que no te diga
    // que hubo un error. En el mejor de los casos les dará una violación de
    // segmento (segmentation fault). Busquen que significa esto.

    // Podemos extender el largo del arreglo en uno agregando un valor al final.
    // Para esto usamos el métido push_back
    vec.push_back(a);
  }

  // La impresion en orden inverso es igual que en el caso anterior. La única
  // diferencia aquí es que en vez de usar n para el largo del vector usamos
  // el método vec.size() que me entrega el largo del vector.
  for (int i = vec.size() -1; i >= 0; --i) {
    cout << vec[i] << endl;
  }
  return 0;
}
