/*
 * -----------------------------------------------------------------------------
 * "THE BEER-WARE LICENSE" (Revision 42):
 * <nlehmann@dcc.uchile.cl> wrote this file. As long as you retain this notice
 * you can do whatever you want with this stuff. If we meet some day, and you
 * think this stuff is worth it, you can buy me a beer in return Nicolás Lehmann
 * -----------------------------------------------------------------------------
 */

// El juego del 3n+1 consiste en elegir un numero y aplicar las siguientes
// reglas reiterativamente:
// 1) Si el número es par dividirlo por dos
// 2) Si el número es impart multipliarlo por tres y sumarle uno
// Se piensa que si se sigue aplicando estas reglas sin importar el número
// del que partas siempre llegarás a uno.
// El siguiente programa asume que lo anterior es cierto. El programa lee un
// número y determina en cuantos pasos se llega a 1 aplicando las reglas
// anteriores.

#include <iostream>
using namespace std;

int main () {
  int n;
  cin >> n;

  // Imprimimos saltos de línea para que no se confunda lo que imprimimos
  // más abajo
  cout << endl << endl;

  // La instrucción while permite ejecutar un trozo de código iterativamente
  // mientras cierta condición se cumpla. La sintáxis es la siguiente
  // while (<condicion>) {
  //   <código>
  // }
  // La semántica es que si la condición se cumple el código denetro del while
  // se ejecuta, luego vuelve a evaluarse la condición y si se sigue cumpliendo
  // se vuelve a ejecutar el códio. Esto se repite hasta que la condición ya
  // no se cumpla. Notar que para que la condición deje de cumplirse dentro del
  // while tiene que ocurrir una modificación, por ejemplo, el actualizar el
  // vaor de una variable.

  // Para contar la cantidad de pasos inicializamos una variable en cero
  // cada vez que el código dentro del while se ejecuta aumentaremos en uno
  // esta variable. Este tipo de variables se llama contador.
  int pasos = 0;

  // La condición para que el while se siga ejecutando es que el número todavía
  // sea distinto de 1. Visto de otra forma dejamos de ejecutar cuando el número
  // sea igual a 1. Notar que el valor de n va cambiando dentro del while y por
  // lo tanto eventualmente llegará a uno (si la conjetura del 3n+1 es cierta)
  while (n != 1) {
    cout << n << endl;  // imprimimos el número para ver que esta pasando

    // El operador % me permite ver cual es el resto de dividir por un número.
    // Se le llama el operador modulo. En este caso vemos si el resto de dividir
    // por dos es 0, en cuyo caso el número es par y debemos dividirlo por dos
    if (n % 2 == 0) {
      n = n/2;
    // Si el número no era par debemos aplicar la otra regla
    } else {
      n = 3*n + 1;
    }

    // Qué pasaría si imprimo aquí n en vez del principio del while?
    // cout << n << endl;

    // Al final de realizar la operación aumentamos en uno el contador
    pasos = pasos + 1;
  }

  // Cuando la condición ya no se cumple la ejecución sigue después del while.
  // Aquí imprimimos la cantidad de pasos.
  cout << "Pasos: " << pasos << endl;

  return 0;
}
