/*
 * -----------------------------------------------------------------------------
 * "THE BEER-WARE LICENSE" (Revision 42):
 * <nlehmann@dcc.uchile.cl> wrote this file. As long as you retain this notice
 * you can do whatever you want with this stuff. If we meet some day, and you
 * think this stuff is worth it, you can buy me a beer in return Nicolás Lehmann
 * -----------------------------------------------------------------------------
 */

#include <iostream>
using namespace std;

int main() {

  // C++ también me permite hacer operaciones aritméticas
  cout << 1 + 1 << endl;
  cout << 4*3 << endl;
  cout << 3-5 << endl;
  cout << 4/2 << endl;

  // Hay que tener cuidado con el orden en que las operaciones
  // son realizadas. Esto se llama la precedencia de los operadores.
  cout << 3*1+10*2/5/2 << endl;

  // C++ sigue la precedencia usual en matemáticas primero * y / de
  // izquierda a derecha y luego + y -. Siempre puedes usar paréntesis
  // por si tienes dudas.
  cout << (5+11)/4 << endl;

  // En C++ un entero no es lo mismo que un número real. Si divides
  // dos enteros el resultado que obtendras es un entero, si la división
  // no es exacta entonces se trunca.
  cout << 5/2 << endl;

  // Para tener división de números reales debes usar números reales o
  // mejor llamados números de punto flotante.
  cout << 5.0/2.0 << endl;

  // C++ es un poquito más inteligente y si operas un número de punto flotante
  // con un entero obtienes un número de punto fotante.
  cout << 5/2.0 << endl;

  // Pero cuidado con el orden en que se hacen las evaluaciones
  cout << 15/2*2.0 << endl;
  // En este caso como la división se realiza primero por ir de izquierda a
  // derecha obtendras primero una división truncada (15/2=7). Luego este
  // resultado será dividido por 2.0 lo cual si dara un real (7/2.0=3.5)
}
