/*
 * -----------------------------------------------------------------------------
 * "THE BEER-WARE LICENSE" (Revision 42):
 * <nlehmann@dcc.uchile.cl> wrote this file. As long as you retain this notice
 * you can do whatever you want with this stuff. If we meet some day, and you
 * think this stuff is worth it, you can buy me a beer in return Nicolás Lehmann
 * -----------------------------------------------------------------------------
 */

#include <iostream>
#include <vector>
using namespace std;

// Ahora veremos un concepto muy importante: funciones.
// A menudo uno se encuetra con código que se repite en varias partes del
// programa. Una función permite abstraer esta funcionalidad y darle un nombre.
// Una función implementa cierto trozo de código el cual puede ser usado en
// varias partes del programa sólo usando el nombre de la función.
// En C++ una función es bastante similar a una función en matemáticas,
// es decir, está toma valores como argumentos y devuelve un valor como
// resultado.


// Haremos un programa que recibe una lista de valores y devuelve su suma.
// Para esto guardaremos los valores en un vector y después llamaremos a una
// función que calcula la suma de los valores del vector.


// Para declarar una función se usa la siguiente sintaxis:
// tipo_retorno nombre(tipo_parametro1 nombre_parametro1, tipo_parametro2 nombre_arametro2,...)
// Por ejemplo la funcion "int foo(int a, double b)" toma como argumentos un
// valor entero y uno real, y retorna un valor entero


// Nuestra función que suma los valores de un vector toma como parametro un
// vector de enteros y devuelve un entero (la suma de los valores)
int sum_vec(vector<int> vec) {
  // Para calcular la suma de un vector inicializamos una variable en 0, luego
  // recorreremos todos los valores del vector e iremos sumandolo a esta
  // variable
  int sum = 0;
  for (int i = 0; i < vec.size(); ++i) {
    sum += vec[i];
  }

  // Para que la función devuelva un valor se usa la instrucción return
  return sum;
}

#include <iostream>
#include <vector>

int main() {
  // Primero leemos los números y los guardamos en un vector.
  int n;
  cin >> n;
  vector<int> my_vec(n);
  for (int i = 0; i < n; ++i) {
    int a;
    cin >> a;
    my_vec[i] = a;
  }

  // Ahora llamamos a la función y guardamos el valor que retorna, el cual
  // corresponde a la suma de los números en el vector.
  int s = sum_vec(my_vec);

  // Ahora imprimimos el valor de la suma
  cout << s << endl;
  return 0;
}
