/*
 * -----------------------------------------------------------------------------
 * "THE BEER-WARE LICENSE" (Revision 42):
 * <nlehmann@dcc.uchile.cl> wrote this file. As long as you retain this notice
 * you can do whatever you want with this stuff. If we meet some day, and you
 * think this stuff is worth it, you can buy me a beer in return Nicolás Lehmann
 * -----------------------------------------------------------------------------
 */


// Hagamos ahora un programa que lee varios enteros y luego los imprime en orden
// invertido. Para poder hacer esto es necesario tener guardado todos los
// números para poder escribirlos desde el final. Para esto usaremos vectores.
// Un vector es un objeto que me permite guardar varios valores a la vez.
// Puede pensarse como una lista de valores.


#include <iostream>
// Para trabajar con vectores en C++ debo incluir el header vector
#include <vector>
using namespace std;


int main() {
  // De forma similar al programa que determinaba el mínimo primero
  // leemos la cantidad de números que nos pasarán.
  int n;
  cin >> n;

  // En C++ un vector solo puede guardar valores de un solo tipo, valores de
  // tipo int, de tipo double...
  // La sintáxis para declarar un vector es la siguiente:
  // vector<tipo> nombre(largo)
  // El tipo corresponde al tipo de valores que guardará el vector. El largo
  // a la cantidad de objetos.
  // Aquí declaramos un vector que guarda enteros y es de tamaño n. Es decir
  // puede guardar n enteros.
  vector<int> vec(n);

  // En un vector los valores se indexan desde cero. Es decir el primer valor
  // del vector corresponde al que está en la posición 0, el segundo a la
  // 1 y así hasta llegar a la posición n - 1, donde n es el largo del vector.

  // Para guardar los valores en el vector haremos un for que parte desde 0 y
  // va hasta n - 1 (por eso usamos desigualdad estricta). i corresponderá a la
  // posición actual en el arreglo
  for (int i = 0; i < n; ++i) {
    // Primero leemos un valor
    int a;
    cin >> a;

    // Para cambiar el valor de una posición de un arreglo usamos la siguiente
    // sintáxis vec[posicion] = valor
    // En este caso guardamos en la posición i el valor a que acabamos de leer.
    vec[i] = a;
  }

  // Ahora podemos imprimir el vector en orden inverso. Para eso recorremos
  // el vector desde la posición final (n-1) hasta la inicial (0)
  for (int i = n -1; i >= 0; --i) {
    // Para acceder al valor en una posición simplemente ocupamos la notación
    // vec[posicion]
    // En este caso accedemos a la posición i usando vec[i]
    cout << vec[i] << endl;
  }

  return 0;
}
