/*
 * -----------------------------------------------------------------------------
 * "THE BEER-WARE LICENSE" (Revision 42):
 * <nlehmann@dcc.uchile.cl> wrote this file. As long as you retain this notice
 * you can do whatever you want with this stuff. If we meet some day, and you
 * think this stuff is worth it, you can buy me a beer in return Nicolás Lehmann
 * -----------------------------------------------------------------------------
 */

// Hagamos un programa que primero lee un numero n y luego lee n números más.
// El programa luego imprime cual es el menor de estos n números.
// La entrada sería algo así
// 5
// 45 23 45 56 56
// El 5 se refiere a que en la siguiente linea vendrán 5 números

#include <iostream>
// El header climits me permite usar el macro INT_MAX que representa el número
// más grande representable en enteros
#include <climits>
using namespace std;




int main () {
  int n;

  cin >> n;

  // La instrucción for nos permite iterar sobre un rango de valores. En
  // estricto rigor nos da la misma funcionalidad del while, pero la sintaxis
  // lo hace más apto para otras tareas.
  // La sintaxis del for es la siguiente
  // for (<inicializacion>; <condicion>; <actualizacion>) {
  //   <código>
  // }
  // En la parte de inicializacion, se deben setear las variables que serán
  // ocupadas. La condicion se refiere a la condición que debe mantenerse para
  // que el código dentro del for se ejecute. Finalmente en la parte de
  // actualización se deben modificar todas variables.
  // La semantica es la siguiente. Primero se inicializan las variables, luego
  // se verifica si se cumple la condición, si se cumple, se ejecuta el código
  // dentro del for. Una vez que termina el código dentro del for, se ejecutan
  // las actualizaciones y luego se vuelve a verifiar la condición para ver sin
  // se termina el for o se vuelve a ejectuar.


  // Para calcular el minimo entre los valores que nos pasan mantendremos una
  // variable que guarda el menor valor visto hasta el momento, cada vez que
  // leemos un nuevo valor verificamos si es menor que el valor que mantenemos
  // en esta variable, en cuyo caso es actualizada.
  // Esta variable parte en un número que es mayor que cualquier número que
  // nos puedan pasar, de esta forma siempre se actualziará con el primer número
  // leído.
  int minimo = INT_MAX;

  // El for parte con una variable i igual a 0 y la va incrementando en uno
  // después de cada iteración. La condición para que el for se ejecute es que
  // este valor sea menor que el número que nos pasan indicando la cantidad
  // de numeros que nos entregarán.
  for (int i = 0; i < n; ++i) {
    // Primero leemos un nuevo numero
    int a;
    cin >> a;

    // Comprobamos si el nuevo número es menor que nuestro valor actual
    // de mínimo. Si este es el caso lo actualizamos
    if (a < minimo) {
      minimo = a;
    }

    // Iprimos pra ver que está pasando. Notar que dentro del for podemos
    // usar el valor de las variables que declaramos (i en este caso)
    // El cout se puede escribir en varias líneas.
    cout << "Después del " << i << "-ésimo número el menor valor es "
         << minimo << endl;
  }

  // Finalmente imprimos el menor valor
  cout << "El menor valor después de leer todos los números es: "
       << minimo << endl;

  return 0;
}
