/*
 * -----------------------------------------------------------------------------
 * "THE BEER-WARE LICENSE" (Revision 42):
 * <nlehmann@dcc.uchile.cl> wrote this file. As long as you retain this notice
 * you can do whatever you want with this stuff. If we meet some day, and you
 * think this stuff is worth it, you can buy me a beer in return Nicolás Lehmann
 * -----------------------------------------------------------------------------
 */

// Hagamos un programa que lee dos números y determina si su suma está entre
// 50 y 100

#include <iostream>
using namespace std;

int main() {
  // Primero leemos los números
  int a, b;
  cin >> a >> b;

  // La sentencia if nos permite decidir entre ejecutar o no una parte del
  // código dependiendo de si cierta condición se cumple.
  // La sintaxis de la instrucción if es la siguiente
  // if (<condicion>) {
  //   <codigo a ejecutar si se cumple la condición>
  // }
  // Donde <condicion> corresponde a una expresión booleana. Una expresión
  // booleana es cualquiera que puede ser evaluada a verdadera o falso, es
  // decir, la condicion tiene que evaluar al tipo bool
  // La forma básica de tener condiciones booleanas es con los operadores de
  // comparación  <, <=, > y >=. Además las condiciones booleanas pueden ser
  // combinadas usando los conectores lógicos && y || que corresponden al "y"
  // y "o" lógicos.

  // La semántica del if es primero evaluar a la condición, si está es verdadera
  // se ejecuta el código dentro de las llaves ({}), en caso contrario se salta
  // esa parte y sigue mas adelante.
  // Una instucción if está tipicamente acompañada de un else de la siguiente
  // forma
  // if (<condicion>) {
  //  <codigo si se cumple condicion>
  // } else {
  //  <codigo si no se eumple condicion>
  // }
  // Esto puede leerse como: si se sumple la condición se ejecuta lo que está
  // dentro del if, si no se cumple la condición, se ejecuta lo que está dentro
  // del else. Decimos que se ejecuta una de las ramas. Luego de ejecutarse una
  // de las ramas (lo del if o lo del else) se continúa ejecutando lo que
  // viene a continuación.

  // Adicionalmente es común encontrar lo siguiente
  // if (<condicion 1>) {
  //   <codigo 1>
  // } else if (<condicion 2>) {
  //   <codigo 2>
  // .
  // .
  // .
  // } else if (<condicion n>) {
  //    <codigo n>
  // } else {
  //    <codigo n+1>
  // }
  // Lo anterior va evaluando las condiciones hasta encontrar la primera que se
  // cumpla y ejecuta sólo la rama asociada a esa condición. Si ninguna de las
  // condiciones se cumplen se ejecuta la rama correspondiente al else.

  // Aquí el código que comprueba si la suma de los números esta entre 50 y 100
  // esto es equivalente a preguntar si la suma es mayor o igual que 50 y a la
  // vez menor o igual que 100.
  if (50 <= a + b && a + b <= 100) {
    cout << "La suma está entre 50 y 100\n";
  } else {
    cout << "La suma no está entre 50 y 100 :-(\n";
  }

  // Después de ejecutarse una de las ramas, la ejecución sigue aquí.
  cout << "Que fácil que es C++\n";

  return 0;
}
