/*
 * -----------------------------------------------------------------------------
 * "THE BEER-WARE LICENSE" (Revision 42):
 * <nlehmann@dcc.uchile.cl> wrote this file. As long as you retain this notice
 * you can do whatever you want with this stuff. If we meet some day, and you
 * think this stuff is worth it, you can buy me a beer in return Nicolás Lehmann
 * -----------------------------------------------------------------------------
 */

// La instrucción include permite decirle al compilador de C++ donde buscar
// las definiciones de algún recurso. En este caso la especificación iostream
// permite trabajar con las funciones para poder leer e imprimir por la pantalla
// #include es una directiva del preprocesador y no termina con ;
#include <iostream>

// Para que no existan conflictos de nombres C++ permite agrupar los nombres
// en namespaces. Todas las funciones de la librería estándar de C++ están
// en el namespace std. Si usamos la instrucción using namespace std podemos
// evitar tener que especificar siempre que los nombres que ocupamos son del
// namespace std.
// Toda instrucción en C++ debe terminar con ;
using namespace std;

// Todo programa en C++ debe tener una función llamada main. Todo lo que está
// dentro de esta función es ejecutado cuando el programa comienza.
int main() {
  // En un programa en C++ las instrucciones terminan con un ;
  // Cada instrucción es ejecutada de forma secuencial una después de otra

  // Para imprimir por pantalla se ocupa [cout]. cout es llamado un stream de
  // salida. El operador [<<] indica que el "flujo" va hacia la salida.
  // Terminamos el string con \n para indicar que hay que hacer un salto de
  // línea.
  cout << "Hello World!\n";
  // Sin [using namespace std] tendríamos que haber escrito [std::cout] poniendo
  // explicitamente que cout están en el namespace std.

  // Se pueden enviar varias cosas a imprimir a la vez. Todo lo que se envía
  // se imprime de forma seguida sin ninguna separación. Si queremos separarlo
  // debemos agregar explicitamente los espacios.
  cout << "C++ " << "is" << " " << "the best\n";

  // También es posible imprimir números. Tambien es posible usar endl para
  // indicar un salto de línea.
  cout << "El número: " << 1 << endl;


  // El main debe retornar siempre 0. En palabras simples devolver 0 significa
  // que el programa termino bien.
  return 0;
}
