class Pol:
	def __init__(self, coef):
		assert type(coef) == list
		for i in coef:
			assert type(i) == int or type(i) == float
		self.__coef = coef

	def valor(self, x):
		total = 0
		for i in range(len(self.__coef)):
			total += self.__coef[i] * x ** i
		return total

	def __str__(self):
		string = ''
		for i in range(len(self.__coef)-1, -1, -1):
			string += str(self.__coef[i])
			string += 'x^'
			string += str(i)
			string += '+'
		return string[:-1]

			



# Tests de valor
ejemplo = Pol([1,2,3])
assert ejemplo.valor(0) == 1
assert ejemplo.valor(1) == 6
assert ejemplo.valor(2) == 17
assert ejemplo.valor(-1) == 2

assert str(ejemplo) == '3x^2+2x^1+1x^0'
