class Tiempo:
	def __init__(self, x, y=0):
		if type(x) == str:
			split_index = x.find(':')
			self.__horas = int(x[:split_index])
			self.__minutos = int(x[split_index+1:])
		else:
			self.__horas = x
			self.__minutos = y


	def __add__(self, otro):
		suma_minutos = self.__minutos + otro.__minutos
		suma_horas = suma_minutos / 60
		suma_horas += self.__horas + otro.__horas
		suma_minutos = suma_minutos % 60
		return Tiempo(suma_horas, suma_minutos)

	def __eq__(self, otro):
		if self.__horas == otro.__horas:
			return self.__minutos == otro.__minutos
		return False

	def __sub__(self, otro):
		dif_horas = self.__horas - otro.__horas
		if self.__minutos >= otro.__minutos:
			dif_minutos = self.__minutos - otro.__minutos
		else:
			dif_horas -= 1
			dif_minutos = 60 - abs(self.__minutos - otro.__minutos)

		if dif_horas < 0:
			return Tiempo(0)
		else:
			return Tiempo(dif_horas, dif_minutos)

	def __gt__(self, otro):
		if self.__horas > otro.__horas:
			return True
		if self.__horas == otro.__horas:
			return self.__minutos > otro.__minutos
		return False

	def __str__(self):
		string = ''
		if 0 <= self.__horas < 10:
			string += '0'
		string  += str(self.__horas)
		string  += ':'
		if self.__minutos < 10:
			string += '0'
		string += str(self.__minutos)
		return string
	
	def minutos(self):
		return self.__horas * 60 + self.__minutos



# Tests de igualdad
assert Tiempo(1,0) == Tiempo(1)
assert Tiempo('1:00') == Tiempo(1)
assert Tiempo(1,30) == Tiempo(1,30)
assert Tiempo('1:00') != Tiempo(1,30)

# Tests de suma
assert Tiempo(1,30) + Tiempo(0,15) == Tiempo(1,45)
assert Tiempo(1,30) + Tiempo(1) == Tiempo(2,30)
assert Tiempo(1,30) + Tiempo(1,15) == Tiempo(2,45)
assert Tiempo(1,30) + Tiempo(0,0) == Tiempo(1,30)
assert Tiempo(1,15) + Tiempo(1,30) == Tiempo(1,30) + Tiempo(1,15)
# Tests de diferencia
assert Tiempo(1,30) - Tiempo(0,30) == Tiempo(1)
assert Tiempo(1,30) - Tiempo(1) == Tiempo(0,30)
assert Tiempo(1,30) - Tiempo(1,20) == Tiempo(0,10)
assert Tiempo(1,30) - Tiempo(2,30) == Tiempo(0)
assert Tiempo(1,30) - Tiempo(0,30) == Tiempo(1)
assert Tiempo(1,30) - Tiempo(0,40) == Tiempo(0,50)
assert Tiempo(1,30) - Tiempo(1,40) == Tiempo(0)

# Tests de mayor que
assert Tiempo(2,30) > Tiempo(1,30)
assert Tiempo(1,30) > Tiempo(1,20)
assert not Tiempo(1,30) > Tiempo(2,30)
assert not Tiempo(1,30) > Tiempo(1,40)
assert not Tiempo(1,30) > Tiempo(1,30)

# Tests de toString
assert str(Tiempo(0,30)) == '00:30'
assert str(Tiempo(1,20)) == '01:20'
assert str(Tiempo(10,30)) == '10:30'
assert str(Tiempo(2)) == '02:00'
# Tests de minutos
assert Tiempo(0,30).minutos() == 30
assert Tiempo(1,30).minutos() == 90

