# -*- coding: utf-8 -*-
# Suponemos que las funciones del enunciado están en el
# modulo funciones
import funciones

# imprimir_fila: int int -> None
# Imprime las representaciones
# en distintas bases de un numero decimal
def imprimir_fila(decimal, b=10):
	if b == 1:
		print
		return
	en_base_n = funciones.aBaseY(decimal, b)
	print en_base_n,
	imprimir_fila(decimal, b-1)

# imprimir_tabla: int -> None
# Imprime las representaciones en distintas bases
# de un todos los enteros entre 10 y 99
def imprimir_tabla(a=99):
	if a == 9:
		# Esto es lo primero que se imprime por lo que queda al 
		# principio de la tabla
		print 'n B9 B8 B7 B6 B5 B4 B3 B2'
		return
	# Notar que si intercambiamos las siguientes instrucciones
	# la tabla se imprime al reves
	imprimir_tabla(a-1)
	imprimir_fila(a)

# dialogo: int int -> None
# Ejecuta un diálogo como se muestra en el enunciado,
# que pide números en distintas bases al usuario
# y al final imprime el mayor npumero ingresado
def dialogo(decimal_maximo=0, n_maximo=10):
	# Guardamos los valores del mayor número ingresado en los argumentos de la función
	n = input('n? ')
	if n == 0:
		print 'el n maximo es: ', n_maximo
		return
	numero = n / 10
	base = n % 10
	base_valida = base > 1
	# Primero revisamos que la base sea válida (entre 2 y 9)
	if base_valida:
		# Luego que el número corresponda a un número válido en esa base
		bien_expresado = funciones.ok(numero, base)
		if bien_expresado:
			# Convertimos el número a decimal para imprirlo y compararlo con el mayor anterior
			decimal = funciones.aBase10(numero, base)
			print 'decimal:', decimal
			m = max(decimal_maximo, decimal)
			if m != decimal_maximo:
				# Si el mayor cambió llamamos a la función con los valores actualizados
				return dialogo(m, n)
		else:
			print 'error en numero'
	else:
		print 'error en base'
	# Si llegamos aquí el número máximo no cambió, 
	# así que llamamos a la función con los mismos valores
	dialogo(decimal_maximo, n_maximo)

# Notemos que ninguna de estas funciones se testea porque todas retornan None