 # -*- coding: utf-8 -*-


# dineroFinal: num float int -> num
# Recibe un monto de dinero inicial, una tasa de interés
# y una cantidad de años y entrega la cantidad de dinero
# que se tiene al final del período usando interés compuesto
def dineroFinal(monto, interes, agnos):
	if agnos == 0: # Caso base
		return monto
	else: # Caso recursivo
		return (1 + interes)*dineroFinal(monto,interes,agnos-1)

assert dineroFinal(1000000, 0.05, 2) == 1102500
assert dineroFinal(1000000, 0.05, 0) == 1000000
assert dineroFinal(1000000, 0, 2) == 1000000

### PROPUESTO ###

# factorial: int -> int
# Recibe un entero positivo y entrega su factorial
# Ejemplo: factorial(5) retorna 120
def factorial(n):
	if n == 0: # Caso base
		return 1
	else: # Caso recursivo
		return n * factorial(n-1)

assert factorial(0) == 1
assert factorial(1) == 1
assert factorial(3) == 6
assert factorial(5) == 120

# f: num int -> num
# Recibe un numero x y un entero positivo i y retorna un valor
# según las reglas del enunciado
# Ejemplo: f(3, 2) retorna -4.5
def f(x, i):
	if i % 2 == 0: #Par
		signo = -1
	else: #impar
		signo = 1
	exponente = 2 * i - 1 
	return signo * (float(x)**(exponente)) / factorial(exponente)

assert f(2,2) == -8.0/6
assert f(1,3) == 1.0/120
assert f(3,2) == -4.5

# sumaPrimerosN: num int -> num
# Recibe un numero x y un entero positivo n, y entrega la suma de los
# primeros n términos de la sucesión definida en el enunciado
def sumaPrimerosN(x, n):
	if n == 1: #Caso base
		return f(x, 1)
	else: # Caso recursivo
		return f(x, n) + sumaPrimerosN(x, n-1)


def valores(primero, ultimo, salto):
	if (primero >= ultimo):
		return
	print 'x = ', primero
	print 'suma = ', sumaPrimerosN(primero, 15)
	return valores(primero + salto, ultimo, salto)

import math

valores(-math.pi, math.pi, math.pi/4)
