 #!/usr/local/bin/python
 # -*- coding: utf-8 -*-

### Pregunta 4 ### 


# instante_a_minutos: int -> int
# Recibe un instante de tiempo en formato HHMM como un entero y 
# lo convierte en minutos
# Ejemplo: instante_a_minutos(1015) retorna 615
def instante_a_minutos(instante):
	horas = instante / 100
	minutos = instante - horas * 100
	return minutos + horas * 60

assert instante_a_minutos(1015) == 615
assert instante_a_minutos(100) == 60
assert instante_a_minutos(330) == 210
assert instante_a_minutos(33) == 33

# minutos_a_instantes: int -> int
# Recibe una cantidad de minutos y entrega el instante de tiempo
# correspondiente en formato HHMM
# Ejemplo: minutos_a_instantes(75) retorna 115
def minutos_a_instantes(minutos):
	horas = minutos / 60
	m = minutos - horas * 60
	return horas * 100 + m

assert minutos_a_instantes(615) == 1015
assert minutos_a_instantes(60) == 100
assert minutos_a_instantes(210) == 330
assert minutos_a_instantes(33) == 33

# diferencia_instantes: int int -> int
def diferencia_instantes(instante1, instante2):
	# Primero pasamos ambos tiempos de HHMM a minutos
	minutos1 = instante_a_minutos(instante1)
	minutos2 = instante_a_minutos(instante2)
	# Luego calculamos la diferencia en minutos
	diferencia =  abs(minutos1 - minutos2)
	# Finalmente pasamos la diferencia a HHMM
	return minutos_a_instantes(diferencia)

assert diferencia_instantes(1015, 1145) == 130
assert diferencia_instantes(1145, 1015) == 130
assert diferencia_instantes(900, 1020) == 120
assert diferencia_instantes(1015, 1015) == 0

#### Propuestos ####

# instanteASegundos: int -> int
# Transforma un instante de tiempo en formato (H)HMMSS a segundos
# Ejemplo: instanteASegundos(101545) entrega 36945

def instanteASegundos(tiempo):
    hh = tiempo / 10000
    tiempo_aux = tiempo - hh*10000
    mm = tiempo_aux / 100
    ss = tiempo_aux % 100

    return hh*60*60 + mm*60 + ss
	
assert instanteASegundos(101545) == 36945


# segundosAInstante: int -> int
# Transforma un instante de tiempo en segundos a formato (H)HMMSS
# Ejemplo: segundosAInstante(36945) entrega 101545 

def segundosAInstante(segundos):
    hh = segundos /3600
    tiempo_aux = segundos - hh*3600
    mm = tiempo_aux / 60
    ss = tiempo_aux % 60

    return hh*10000 + mm*100 + ss
	
assert segundosAInstante(36945) == 101545


# sumaInstantes: int int -> int
# Suma dos instantes de tiempo en formato (H)HMMSS
# Ejemplo: sumaInstantes(101545, 113216) entrega 214801 

def sumaInstantes(instante1,instante2):
    t1 = instanteASegundos(instante1)
    t2 = instanteASegundos(instante2)
    suma = t1 + t2
    return segundosAInstante(suma)
	
assert sumaInstantes(101545, 113216) == 214801


# restaInstantes: int int -> int
# Resta dos instantes de tiempo en formato (H)HMMSS (en valor absoluto)
# Ejemplo: restaInstantes(101545, 113216) entrega 214801 

def restaInstantes(instante1,instante2):
    t1 = instanteASegundos(instante1)
    t2 = instanteASegundos(instante2)
    resta = abs(t1-t2)
    return segundosAInstante(resta)

assert restaInstantes(101545, 113216) == 11631

#instanteAString: int -> str
#convierte un instante de tiempo en formato (H)HMMSS a un string de la forma '(H)H:MM:SS'
#ej:    restaInstantes(101545) entrega '10:15:45'

def instanteAString(instante):
    hh = instante / 10000
    tiempo_aux = instante - hh*10000
    mm = tiempo_aux / 100
    ss = tiempo_aux % 100
    return str(hh)+':'+str(mm)+':'+str(ss)

assert instanteAString(101545) == '10:15:45'
