#numeros: dict
class Grupo:

	# __init__: None -> Grupo
	# retorna un objeto de la clase grupo con un diccionario vacio
	def __init__(self):
		self.numeros = {}

	# agregar int -> None
	# agrega el elemento al diccionario. Si no esta en el diccionario, crea la entrada en el diccionario.
	# si ya estaba, suma uno a la cantidad actual.
	def agregar(self,x):
		if x in self.numeros.keys():
			self.numeros[x] = self.numeros[x] + 1
		else:
			self.numeros[x] = 1

	# sacarMayot: None -> int
	# retorna el mayor elemento del diccionario, disminuyendo en 1 el valor de ese elemento en el diccionario.
	# Si el valor llega a 0, la entrada con ese elemento es eliminado del diccionario.
	def sacarMayor(self):
		if len(self.numeros.keys()) == 0:
			return None
		mayor = max(self.numeros.keys())
		self.numeros[mayor] -= 1
		if self.numeros[mayor] == 0:
			del self.numeros[mayor]
		return mayor

#tests
g = Grupo()
assert g.sacarMayor() == None
g.agregar(3)
g.agregar(5)
g.agregar(8)
g.agregar(5)
assert g.sacarMayor() == 8
assert g.sacarMayor() == 5
assert g.sacarMayor() == 5
assert g.sacarMayor() == 3
assert g.sacarMayor() == None