# Clase para representar un momento de tiempo
class Tiempo:

	# Constructor para la clase. Funciona de 3 maneras:
	# 1.- Se entregan horas y minutos como int
	# 2.- Se entregan solo horas y los minutos son 0
	# 3.- Se entrega la hora como string
	def __init__(self,x,y=0):
		horas = x
		minutos_totales = y
		if type(x) == str:
			indice = x.index(":")
			horas = int(x[0:indice])
			minutos_totales = int(x[indice+1:])
		minutos = minutos_totales%60
		self.__horas = horas + minutos_totales/60
		self.__minutos = minutos

	# __str__: Tiempo -> string
	# Funcion para mostrar la representacion en string de un Tiempo
	# str(Tiempo(2,30)) =  "2:30"
	def __str__(self):
		ceros = 2-len(str(self.getMinutos()))
		return str(self.getHoras())+":"+"0"*ceros+str(self.getMinutos())

	# __add__: Tiempo Tiempo -> Tiempo
	# suma dos tiempos distintos
	# ej: Tiempo("2:30") + Tiempo(8) == Tiempo(10,30)
	def __add__(self,x):
		minutos = self.__minutos + x.__minutos
		horas = self.__horas + x.__horas
		unTiempo = Tiempo(horas,minutos)
		return unTiempo	

	# __sub__: Tiempo Tiempo -> Tiempo
	# resta dos tiempos distintos
	# ej: Tiempo("2:30") - Tiempo(8) == Tiempo(-6,30)
	def __sub__(self,x):
		minutos = self.__minutos - x.__minutos
		horas = self.__horas - x.__horas
		unTiempo = Tiempo(horas,minutos)
		return unTiempo

	# __gt__: Tiempo Tiempo -> Tiempo
	# compara dos tiempos retornando si el primero es mayor al segundo
	# ej: Tiempo("2:30") > Tiempo(8) == False
	def __gt__(self,x):
		if self.__horas>x.__horas:
			return True
		elif self.__horas<x.__horas:
			return False
		else:
			if self.__minutos>x.__minutos:
				return True
			else:
				return False

	# __gt__: Tiempo Tiempo -> Tiempo
	# compara dos tiempos retornando si el primero es menor al segundo
	# ej: Tiempo("2:30") > Tiempo(8) == True
	def __lt__(self,x):
		if self.__horas<x.__horas:
			return True
		elif self.__horas>x.__horas:
			return False
		else:
			if self.__minutos<x.__minutos:
				return True
			else:
				return False

	# Compara dos objetos de la clase tiempo para ver si son iguales
	def __eq__(self,x):
		return self.__horas == x.__horas and self.__minutos == x.__minutos

	# Método para poder accesar a las horas de un objeto de la clase tiempo desde fuera de la clase
	def getHoras(self):
		return self.__horas

	# Método para poder accesar a los minutos de un objeto de la clase tiempo desde fuera de la clase
	def getMinutos(self):
		return self.__minutos


assert str(Tiempo("7:30")) == "7:30"
assert str(Tiempo(8,30)) == "8:30"
assert Tiempo("2:30") + Tiempo(8) == Tiempo(10,30)
assert Tiempo("2:30") - Tiempo(8) == Tiempo(-6,30)
assert not Tiempo("2:30") > Tiempo(8)
assert Tiempo("2:30") < Tiempo(8)