#Clase para representar un polinomio
class Pol:
	#Constructor de la clase, recibe una lista con los valores de cada coeficiente
	def __init__(self, lista):
		assert type(lista) == list
		self.lista = lista

	# __str__: Pol -> string
	# Funcion para mostrar la representacion en string de un polinomio
	# Ej: a = Pol([1,2,3]) # polinomio 3x^2 + 2x +1
	# str(a) =  "3x^2 + 2x +1"
	def __str__(self):
		retorno = ""
		for i in range(len(self.lista)-1,-1,-1):
			retorno += str(self.lista[i])+"x^" + str(i) + " + "
		retorno = retorno[0:len(retorno)-3]
		return retorno
	

	# valor: Pol, int -> int
	# Funcion para ver el valor del polinomio en un valor
	# Ej: Pol([1,2,3]).valor(2) == 17
	def valor(self,x):
		retorno = 0
		for i in range(len(self.lista)-1,-1,-1):
			retorno += self.lista[i]*x**i
		return retorno
		
#Test definidos fuera de la clase para poder usar la clase
assert str(Pol([1,2,3])) == "3x^2 + 2x^1 + 1x^0"
assert  Pol([1,2,3]).valor(2) == 17