# -*- coding: utf-8 -*-

from lista import *
from funciones import *

# Para los tests
l0 = lista(0, None)
l1 = lista(1, lista(2, lista(3, None)))
l2 = lista(3, lista(2, lista(1, None)))

# binario: int -> str
# Funcion para calcular binarios
def binario(x):
	assert type(x) == int and x >= 0
	if x==0:
		return "0"
	elif x==1:
		return "1"
	else:
		return binario(x/2) + str(x%2)
		
assert binario(2) == "10"
assert binario(5) == "101"
assert binario(10) == "1010"
assert binario(8) == "1000"


# listaDecimalABinario: lista -> lista
# Recibe una lista de números decimales y los convierte a bianrio
# ej. listaDecimalABinario(lista(2, lista(3, None))) da lista(10, lista(11, None))
def listaDecimalaBinario(L):
	assert esLista(L)
	if L==None:
		return None
	else:
		return lista( binario(L.valor), listaDecimalaBinario(L.sgte))
assert listaDecimalaBinario(l0) == lista("0", None)
assert listaDecimalaBinario(l1) == lista("1", lista("10", lista("11", None)))
assert listaDecimalaBinario(l2) == lista("11", lista("10", lista("1", None)))


# Con mapa

# listaDecimalABinario2: lista -> lista
# Recibe una lista de números decimales y los convierte a bianrio
# ej. listaDecimalABinario2(lista(2, lista(3, None))) da lista(10, lista(11, None))
def listaDecimalaBinario2(L):
	return mapa(binario, L)
assert listaDecimalaBinario2(l0) == lista("0", None)
assert listaDecimalaBinario2(l1) == lista("1", lista("10", lista("11", None)))
assert listaDecimalaBinario2(l2) == lista("11", lista("10", lista("1", None)))