# -*- coding: utf-8 -*-
import estructura
from lista import *

# registro -> nombre (String), numero (int)
estructura.crear("registro", "nombre numero")
# redSocial -> numero(int), usuario (String)
estructura.crear("redSocial", "numero usuario")
# registroCompleto -> nombre (String), twitter (String), facebook (String)
estructura.crear("registroCompleto", "nombre twitter facebook")

# tamaño 5
lNombres = lista(registro("Tamara", 123),
                 lista(registro("Fernando", 456),
                       lista(registro("Javiera", 789),
                             lista(registro("Camilo", 987),
                                   lista(registro("Carolina", 654),
                                         None)))))
# tamaño 5
lTwitter = lista(redSocial(123, "@tamara"),
                 lista(redSocial(654, "@carolina"),
                       lista(redSocial(111, "@alguien"),
                             lista(redSocial(444, "@otro"),
                                   lista(redSocial(789, "@javi"),
                                         None)))))

# tamaño 4
lFacebook = lista(redSocial(456, "fernando.f"),
                  lista(redSocial(965, "a.b"),
                        lista(redSocial(123, "tamy.o"),
                              lista(redSocial(666, "the.number.of.the.beast"),
                                    None))))

# tamaño 5
lEsperada = lista(registroCompleto("Tamara", "@tamara", "tamy.o"),
                  lista(registroCompleto("Fernando", None, "fernando.f"),
                        lista(registroCompleto("Javiera", "@javi", None),
                              lista(registroCompleto("Camilo", None, None),
                                   lista(registroCompleto("Carolina", "@carolina", None),
                                         None)))))

# buscar :: int lista(redSocial) -> String
# dado un numero, entrega el usuario de red social asociado a ese numero, y None si es que no lo encuentra
# Ej: buscar(111, lTwitter) = @alguien
def buscar(numeroABuscar, lista):
    if lista == listaVacia:
        return None
    
    registroRedSocial = cabeza(lista)
    if registroRedSocial.numero == numeroABuscar:
        return registroRedSocial.usuario

    return buscar(numeroABuscar, cola(lista))

# Tests
assert buscar(111, lTwitter) == "@alguien"
assert buscar(101, lFacebook) == None

# generarListaDeContactos : lista(registro) lista(redSocial) lista(redSocial) -> lista(registroCompleto)
# Dada una lista de registros (nombre, numero), busca si es que ese numero tiene asociado un facebook y un twitter
# en las listas correspondientes, y luego crear un registroCompleto(nombre, twitter, facebook) con los datos encontrados
# Ej: generarListaDeContactos(lNombres, lTwitter, lFacebook) = lEsperada
def generarListaDeContactos(listaRegistros, listaTwitter, listaFacebook):
    if listaRegistros == listaVacia:
        return None

    nombreActual = cabeza(listaRegistros).nombre
    numeroActual = cabeza(listaRegistros).numero
    twitter = buscar(numeroActual, listaTwitter)
    facebook = buscar(numeroActual, listaFacebook)

    return lista(registroCompleto(nombreActual, twitter, facebook),
                 generarListaDeContactos(cola(listaRegistros), listaTwitter, listaFacebook))
# Test
assert generarListaDeContactos(lNombres, lTwitter, lFacebook) == lEsperada



