# -*- coding: utf-8 -*-
import math
from lista import *

# agregarNumeroALista :: num list(num) -> num
# Agrega recursivamente los dígitos de un número a una lista
# Se utiliza como función auxiliar de convertirALista
def agregarNumeroALista(n, lista):
    if n == 0:
        return lista
    modulo = n % 10
    division = n / 10
    return agregarNumeroALista(division, crearLista(modulo, lista))

# convertirALista :: num -> list(num)
# convierte un rut en una lista de dígitos
# Ej: convertirALista(123) entregará lista(1, lista(2, lista(3, listaVacia)))
def convertirALista(rut):
    return agregarNumeroALista(rut, listaVacia)

assert convertirALista(1234765) == lista(1, lista(2, lista(3, lista(4, lista(7, lista(6, lista(5, listaVacia)))))))
    
# invertirLista :: list(X) list(X) -> list(X)
# invierte el orden de una lista, haciendo llamados recursivos y pasando como segundo parámetro
# la lista con los elementos que ya hemos invertido
# Ej: L = lista(1, lista(2, lista(3, listaVacia))) 
# invertirLista(L, listaVacia) entregará lista(3, lista(2, lista(1, listaVacia)))
def invertirLista(listaPorInvertir, listaYaInvertida):
    if vacia(listaPorInvertir):
        return listaYaInvertida
    else:
        return invertirLista(cola(listaPorInvertir), \
                             crearLista(cabeza(listaPorInvertir), listaYaInvertida))

L = lista(1, lista(2, lista(3, listaVacia)))
assert invertirLista(L, listaVacia) == lista(3, lista(2, lista(1, listaVacia)))


# multiplicarPorSecuencia :: list(num) list(num) -> list(num)
# Algo parecido al producto punto entre dos vectores, sólo que en este caso no es necesario que ambos sean
# del mismo tamaño; sólo se exige que el largo de secuencia sea mayor o igual al de listaRut
# Ej: L = lista(1, lista(2, lista(3, listaVacia)))
# S = lista(9, lista(7, lista(11, lista(5, listaVacia))))
# multiplicarPorSecuencia(L, S) entregará lista(9, lista(14, lista(33, listaVacia)))
def multiplicarPorSecuencia(listaRut, secuencia):
    if vacia(listaRut):
        return listaVacia
    else:
        return crearLista(cabeza(listaRut) * cabeza(secuencia), \
                          multiplicarPorSecuencia(cola(listaRut), cola(secuencia)))

secuencia = lista(2, lista(3, lista(4, lista(5, lista(6, lista(7, lista(2, lista(3, lista(4, lista(5, lista(6, lista(7, listaVacia))))))))))))

assert multiplicarPorSecuencia(invertirLista(convertirALista(648), listaVacia), secuencia) == (lista(16, lista(12, lista(24, listaVacia))))

# sumatoriaLista :: list(num) -> num
# retorna la sumatoria de todos los elementos de una lista
# Ej: L = lista(1, lista(2, lista(3, listaVacia)))
# sumatoriaLista(L) = 6
def sumatoriaLista(lista):
    if vacia(lista):
        return 0
    else:
        return cabeza(lista) + sumatoriaLista(cola(lista))

assert sumatoriaLista(secuencia) == 54


# digitoVerificador :: num -> String
# Dado un rut, entrega su dígito verificador (en forma de string)
# Ej: digitoVerificador(172845) entrega 8
def digitoVerificador(rut):
    secuencia = lista(2, lista(3, lista(4, lista(5, lista(6, lista(7, lista(2, lista(3, lista(4, listaVacia)))))))))
    listaRut = convertirALista(rut)
    rutInvertido = invertirLista(listaRut, listaVacia)
    listaFactores = multiplicarPorSecuencia(rutInvertido, secuencia)
    sumaFactores = sumatoriaLista(listaFactores)
    resto = sumaFactores % 11
    digito = 11 - resto
    if digito == 11:
        return 0
    elif digito == 10:
        return "K"
    else: # digito != 11 and digito != 10
        return str(digito)

assert digitoVerificador(172845) == "8"
















    