import estructura
from lista import *

# nodo -> valor (int), izq (nodo), der (nodo)
estructura.crear("nodo", "valor izq der")

arbolBinario = nodo(-1, nodo(0, None, None),
                    nodo(1, nodo(2, nodo(4, None, None), nodo(5, None, None)),
                         nodo(3, nodo(6, None, None), nodo(7, None, None))))

def entregarDecimal(a, lista):
    if lista == listaVacia:
        return a.valor
    elif cabeza(lista) == 0:
        return entregarDecimal(a.izq, cola(lista))
    else: # cabeza(lista) == 1
        return entregarDecimal(a.der, cola(lista))

assert entregarDecimal(arbolBinario, lista(1, lista(1, lista(0, None)))) == 6
assert entregarDecimal(arbolBinario, lista(1, lista(0, lista(0, None)))) == 4
assert entregarDecimal(arbolBinario, lista(1, lista(0, None))) == 2
assert entregarDecimal(arbolBinario, None) == -1


def chequear(a):
    if a.valor != -1:
        return False
    izq = a.izq
    if izq.valor != 0 or izq.izq != None or izq.der != None:
        return False

    return a.der.valor == 1 and verificar(a.der)

def cantidad(arbol):
    if arbol == None:
        return 0
    else:
        return 1 + cantidad(arbol.izq) + cantidad(arbol.der)

def verificar(a):
    if a == None:
        return True
    
    valor = a.valor

    izqOk = (a.izq == None) or (a.izq.valor == 2*valor and verificar(a.izq))
    derOk = (a.der == None) or (a.der.valor == 2*valor + 1 and verificar(a.der))

    return izqOk and derOk and cantidad(a.izq) == cantidad(a.der)



arbolMalo = nodo(-1, nodo(0, nodo(1, None, None), None),
                     nodo(1, None, None))

arbolChicoYBueno = nodo(-1, nodo(0, None, None),
                        nodo(1, None, None))
arbolConNodosFaltantes = nodo(-1, nodo(0, None, None),
                              nodo(1, nodo(2, nodo(4, None, None), nodo(5, None, None)),
                                   nodo(3, None, None)))
arbolConRelacionesMalas = nodo(-1, nodo(0, None, None),
                               nodo(1, nodo(2, nodo(4, None, None), nodo(5, None, None)),
                                    nodo(3, nodo(6, None, None), nodo(8, None, None))))
assert chequear(arbolBinario)
assert chequear(arbolChicoYBueno)
assert not chequear(arbolMalo)
assert not chequear(arbolConNodosFaltantes)
assert not chequear(arbolConRelacionesMalas)

    
