# -*- coding: utf-8 -*-

import structure
from lista import *
structure.crear("nodoABB", "numero izq der")

# cerca :: num num num -> bool
# retorna True si es que |x-y| < e, False en caso contrario
def cerca(x, y, e):
    return abs(x - y) < e

# Éste es el árbol que utilizaremos a lo largo del ejercicio
A = nodoABB(15, nodoABB(9, nodoABB(7, None, None), nodoABB(10, None, None)), \
            nodoABB(25, nodoABB(17, None, None), nodoABB(30, None, None)))

# sumatoriaArbol :: nodoABB -> int
# Dado un árbol, suma todos los valores en los nodos de ese árbol
# Ej: sumatoriaArbol(A) = 113 (15 + 9 + 7 + 10 + 25 + 17 + 30)
def sumatoriaArbol(nodo):
    if nodo == None:
        return 0
    else:
        return nodo.numero + sumatoriaArbol(nodo.izq) + sumatoriaArbol(nodo.der)

assert sumatoriaArbol(A) == 113

def verificarArbol(nodo):
	if nodo == None:
		return True
	else:
		izqOk = (nodo.izq == None) or (nodo.izq.numero < nodo.numero and verificarArbol(nodo.izq))
		derOk = (nodo.der == None) or (nodo.der.numero > nodo.numero and verificarArbol(nodo.der))
		return izqOk and derOk

# elementosArbol :: nodoABB -> int
# retorna la cantidad de elementos en un árbol
# Ej: elementosArbol(A) == 7
def elementosArbol(nodo):
    if nodo == None:
        return 0
    else:
        return 1 + elementosArbol(nodo.izq) + elementosArbol(nodo.der)


assert elementosArbol(A) == 7

# promedioArbol :: nodoABB -> num
# retorna el promedio de los valores dentro del árbol
# Ej: promedioArbol(A) debe entregar un valor muy cercano a 113/7
def promedioArbol(nodo):
    return 1.0*sumatoriaArbol(nodo)/elementosArbol(nodo)

assert cerca(promedioArbol(A), 1.0*113/7, 0.0001) 


# numerosEnIntervalo :: nodoABB num num list(num) -> list(num)
# retorna una lista con todos los números en el árbol con raíz unABB, tal que
# el valor de cada uno de esos números está entre n1 y n2
# (se asume que n1 <= n2).
# En listaActual guardamos la lista con los números que ya tenemos ordenados;
# por ende, la primera vez que llamamos a la función debemos pasarle la listaVacia
# Ej: A = nodoABB(15, nodoABB(9, nodoABB(7, None, None), nodoABB(10, None, None)), \
#            nodoABB(25, nodoABB(17, None, None), nodoABB(30, None, None)))
# numerosEnIntervalo(A, 9, 20, listaVacia) entregará lista(9, lista(10, lista(15, lista(17, listaVacia))))
def numerosEnIntervalo(unABB, n1, n2, listaActual):
    if unABB == None:
        return listaActual
    else:
        if unABB.numero < n1:
            return numerosEnIntervalo(unABB.der, n1, n2, listaActual)
        elif unABB.numero >= n1 and unABB.numero <= n2:
            return numerosEnIntervalo(unABB.izq, n1, n2, \
                                      crearLista(unABB.numero,
                                                 numerosEnIntervalo(unABB.der, n1, n2, listaActual)))
        else: # unABB.numero > n2
            return numerosEnIntervalo(unABB.izq, n1, n2, listaActual)

# Explicación:
# Piénsenlo así: n1 y n2 nos particionan el espacio de los reales en
# 3 partes: los números menores a n1, los que están entre n1 y n2, y los mayores a n2
# Además, lo que nosotros tenemos es un ABB, lo que implica que todos los nodos
# a la izquierda de un nodo tendrán valores menores, y todos los nodos a la derecha serán mayores
# Ahora, sea "n" el nodo donde estoy ahora, y "x" el valor de ese nodo (x = nodo.numero)
# Luego, si x < n1, sabemos que todos los que están a la izquierda del nodo actual también serán
# menores a x, y por ello no es necesario revisar esa rama (y revisamos sólo la derecha)
# Análogo para el caso en que x > n2
# Finalmente, si n1<=x and x<=n2 : entonces sabemos que x debe estar en la lista de elementos a retornar.
# Además, sabemos que x debe estar "al medio", entre los elementos que se encuentran a su izquierda y los que se encuentran
# a su derecha (esto, porque queremos entregar una lista ordenada). 
# Luego, para preservar el orden, el primer llamado que haremos será con la rama derecha (digamos que esto nos retorna una lista D)
# Teniendo esa lista calculada, haremos el llamado en la rama izquierda, pasándole como parámetro de listaActual
# la lista(x, D). Como el orden se preserva, finalmente obtendremos los valores en orden.
# Eso, si tienen dudas (sé que las tendrán porque es complejo ._.) consulten! (:


# tests
assert numerosEnIntervalo(A, 35, 40, listaVacia) == listaVacia
assert numerosEnIntervalo(A, 7, 30, listaVacia) == lista(7, lista(9, lista(10, lista(15, lista(17, lista(25, lista(30, listaVacia)))))))
assert numerosEnIntervalo(A, 6, 31, listaVacia) == lista(7, lista(9, lista(10, lista(15, lista(17, lista(25, lista(30, listaVacia)))))))
assert numerosEnIntervalo(A, 16, 19, listaVacia) == lista(17, listaVacia)
assert numerosEnIntervalo(A, 9, 20, listaVacia) == lista(9, lista(10, lista(15, lista(17, listaVacia))))
assert numerosEnIntervalo(A, 20, 25, listaVacia) == lista(25, listaVacia)
assert numerosEnIntervalo(A, 25, 25, listaVacia) == lista(25, listaVacia)
assert numerosEnIntervalo(A, 9, 19, listaVacia) == lista(9, lista(10, lista(15, lista(17, listaVacia))))
