# -*- coding: utf-8 -*-

import estructura

# Nodo: valor(str) izq(Nodo) der(Nodo)
estructura.crear("Nodo", "valor izq der")


# esNodo: Nodo -> bool
# indica si una estuctura es un nodo valido o no
def esNodo(n):
	assert n==None or type(n)==Nodo
	if type(n) == Nodo:
		return esNodo(n.izq) and esNodo(n.der)
	return True


# tamano: Nodo -> int
# recorre el arbol en preorden imprimiendo su contenido y entrega la cantidad total de nodos del arbol
# ej. tamano(Nodo("1", Nodo("2",None,None), Nodo("3",None, None))) entrega 3 
def tamano(n):
	assert esNodo(n)
	if n == None:
		return 0
	else:
		print n.valor
		tamanoIzq = tamano(n.izq)
		tamanoDer = tamano(n.der)
		return 1 + tamanoIzq + tamanoDer
assert tamano(Nodo("1", Nodo("2",None,None), Nodo("3",None, None))) == 3


# tieneValor: Nodo string -> bool
# dice si el nodo dado tiene al string como valor
# ej. tieneValor(Nodo("2", None, None), "2") entrega True
def tieneValor(n, s):
	assert esNodo(n) and type(s) == str
	if n == None:
		return False
	else:
		return n.valor == s

# esPadre: Nodo string string -> bool
# dice si el nodo de valor s1 es padre del nodo con valor s2
# ej. esPadre(Nodo("1", Nodo("2",None,None), Nodo("3",None, None)), "1", "3") entrega True
def esPadre(n, s1, s2):
	assert esNodo(n) and type(s1) == str and type(s2) == str
	if n == None:
		return False
	elif n.valor == s1:
		if tieneValor(n.der, s2) or tieneValor(n.izq, s2):
			return True
		else:
			return esPadre(n.der, s1, s2) or esPadre(n.izq, s1, s2)
	else:
		return esPadre(n.der, s1, s2) or esPadre(n.izq, s1, s2)
assert esPadre(Nodo("1", Nodo("2",None,None), Nodo("3",None, None)), "1", "3")


# esAbuelo: Nodo str str -> bool
# dice si el nodo de valor s1 es abuelo del nodo s2 en el arbol n
# esAbuelo(Nodo("1", Nodo("2", Nodo( "5", None, None),None), Nodo("3",None, None)), "1", "5") entrega True
def esAbuelo(n, s1, s2):
	assert esNodo(n) and type(s1) == str and type(s2) == str
	if n == None:
		return False
	elif n.valor == s1:
		if n.izq != None:
			if esPadre(n.izq, n.izq.valor, s2):
				return True
		if n.der != None:
			if esPadre(n.der, n.der.valor, s2):
				return True
	else:
		return esAbuelo(n.izq, s1, s2) or esAbuelo(n.der, s1, s2)
assert esAbuelo(Nodo("1", Nodo("2", Nodo( "5", None, None),None), Nodo("3",None, None)), "1", "5")
assert not esAbuelo(Nodo("3", Nodo("2", Nodo( "5", None, None),None), Nodo("3",None, None)), "1", "5")