# -*- coding: utf-8 -*-

from lista import *
from funciones import *

# Para los tests
l0 = lista(0, None)
l1 = lista(1, lista(2, lista(3, None)))
l2 = lista(3, lista(2, lista(1, None)))
l3 = lista(3, lista(2, lista(2, None)))

# pares: lista(int) -> lista(int)
# Recibe una lista de números L y retorna una nueva lista que sólo contiene los números pares de la lista
# ej. pares(lista(1, lista(2, lista(3, None)))) da lista(2,None)
def pares(L):
	assert esLista(L)
	if L == None:
		return L
	else:
		if L.valor%2==0:
			return lista(L.valor, pares(L.sgte))
		else:
			return pares(L.sgte)
assert pares(l0) == l0
assert pares(l1) == lista(2, None)
assert pares(l2) == lista(2, None)
assert pares(l2) == pares(l1)
assert pares(l3) == lista(2, lista(2, None))


#### Usando Filtro

# esDivisiblePor: int int -> bool
# Dados dos números, retorna si el primero es divisible por el segundo o no
# Ej. esDivisiblePor(2,2) da True
def esDivisiblePor(valor, div):
	return valor%div == 0	

assert esDivisiblePor(2,2)
assert esDivisiblePor(4,2)
assert esDivisiblePor(9,3)
assert not esDivisiblePor(5,2)



# pares2: lista(int) -> lista(int)
# Recibe una lista de números L y retorna una nueva lista que sólo contiene los números pares de la lista
# ej. pares2(lista(1, lista(2, lista(3, None)))) da lista(2,None)
def pares2(L):
	return filtro(L, esDivisiblePor, 2)

assert pares2(l0) == l0
assert pares2(l1) == lista(2, None)
assert pares2(l2) == lista(2, None)
assert pares2(l2) == pares2(l1)
assert pares2(l3) == lista(2, lista(2, None))