# -*- coding: utf-8 -*-

from lista import *


# alFinal: any lista(any) -> lista(any)
# Agrega un valor al final de una lista
# Ej: alFinal(3,lista(1,lista(2,None))) debe entregar lista(1,lista(2,lista(3,None))) 
def alFinal(V,L):
	assert esLista(L) and type(V) == int
	if L == None:
		return lista(V, L)
	else:
		return lista( L.valor, alFinal(V, L.sgte))
assert alFinal(3,lista(1,lista(2,None))) == lista(1,lista(2,lista(3,None))) 
assert alFinal(3,lista(1,None)) == lista(1,lista(3,None))


# inverso: lista(any) -> lista(any)
# Invierte los elementos de una lista
# Ej: inverso(lista(3,lista(2,lista(1,None)))  debe entregar lista(1,lista(2,lista(3,None)))
def inverso(L):
	assert esLista(L)
	if L == None:
		return None
	else:
		return alFinal(L.valor, inverso(L.sgte))
assert inverso(lista(3,lista(2,lista(1,None)))) == lista(1,lista(2,lista(3,None)))
assert inverso(lista(3,lista(1,None))) == lista(1,lista(3,None))
assert inverso(lista(1,None)) == lista(1,None)