# -*- coding: utf-8 -*-

from lista import *

#filtro: lista(any) (any any->bool) any -> lista(any)
#lista con valores de L que cumplen comparacion con x
#ej:filtro(lista(5,lista(4,None)),menorQue,5)->lista(4,None)
def filtro(L,comparacion,x):
	assert esLista(L)
	if L==None: 
		return None
	elif comparacion(cabeza(L),x):
		return lista(cabeza(L),filtro(cola(L),comparacion,x))
	else:
		return filtro(cola(L),comparacion,x)


#mapa: (any->any) lista(any) -> lista(any)
#lista aplicando funcion a valores de L
#ej: mapa(f,lista(5,lista(4,None))) ->
#    lista(f(5),lista(f(4),None))
def mapa(funcion, L):
    assert esLista(L)
    if L==None: return None
    y=funcion(cabeza(L))
    return lista(y,mapa(funcion,cola(L)))