#P1 - Auxiliar 4
import estructura
estructura. crear("tiempo", "horas minutos")

# esTiempo: tiempo -> bool
# Valida que sea un instante de tiempo valido
# ej: esTiempo(tiempo(10,45)) es True
# esTiempo(tiempo(10,62)) arroja un error
def esTiempo(T):
	assert type(T) == tiempo
	assert type(T. horas) == int and type(T. minutos) == int
	assert T. horas >= 0
	assert 0 <= T. minutos < 60
	# el anterior es equivalente a: assert T.minutos >=0 and T.minutos < 60
	return True
#Test
assert esTiempo(tiempo(10, 45)) # el == True se puede omitir.

# aString: tiempo -> none
# Escribe en pantalla el tiempo, en formato "HH:MM"
# Ej: escribir( tiempo(10,45) ) imprime en pantalla "10:45"
#Cuidado con usar nombres de variable que se llamen igual que la estructura
#ya que puede producir inconsistencias.
def aString(T):
	assert esTiempo(T)
	if T. minutos<10:
		return str(T. horas) + ":" + "0" + str(T. minutos)
	else: #Porque no podemos omitir este else? Bingo!, porque imprimiriamos 2 veces la hora
		return str(T. horas) + ":" + str(T. minutos)
#Test: no es testeable, puesto que retorna none

# enMinutos: tiempo -> int
# Entrega el valor del tiempo, expresado solo en minutos.
# Ej: enMinutos(tiempo(3,50)) entrega 230
def enMinutos(T):
	assert esTiempo(T)
	return T. horas * 60 + T. minutos
#Test
assert enMinutos(tiempo(3, 50)) == 230
assert enMinutos(tiempo(0, 0)) == 0

# sumar: tiempo tiempo -> tiempo
# Entrega la suma de dos tiempos, respetando la restriccion minutos <60
# Ej: sumar(tiempo(9,4),tiempo(3,40)) entrega tiempo(12,44)
# sumar(tiempo(1,50),tiempo(3,23)) entrega tiempo(5,13)
def sumar(T1, T2):
	assert esTiempo(T1) and esTiempo(T2)
	horas = T1. horas + T2. horas
	minutos = T1. minutos + T2. minutos
	#si se superan los 60 min, hay que sumar 1 hora al "reloj"
	if minutos > 60:
		minutos = minutos - 60
		horas = horas + 1
	return tiempo(horas, minutos)
#Test
assert sumar(tiempo(9, 4), tiempo(3, 40))==tiempo(12, 44) #caso < 60 min
assert sumar(tiempo(1, 50), tiempo(3, 23))==tiempo(5, 13) #caso >=60 min

# restar: tiempo tiempo -> tiempo
# Entrega la resta de dos instantes de tiempo. No existen los tiempos negativos
# Ej: restar(tiempo(9,4), tiepo(3,40)) entrega tiempo(5,24)
def restar(T1, T2):
	assert esTiempo(T1) and esTiempo(T2)
	minutos = T1. minutos - T2. minutos
	horas = T1. horas - T2. horas
	#si los minutos nos da negativo, entonces tenemos que quitarle 1 hora al "reloj"
	if minutos < 0:
		horas = horas -1
		minutos = minutos + 60
	#si las horas son negativas, dado que no existen tiempos negativos, retornamos la hora 0
	if horas < 0:
		return tiempo(0, 0)
	#si llegamos a este punto, entonces esta todo ok
	return tiempo(horas, minutos)
#Test
assert restar(tiempo(9, 4), tiempo(3, 40)) == tiempo(5, 24) #caso normal
assert restar(tiempo(1, 50), tiempo(3, 23)) == tiempo(0, 0) #caso tiempo negativo

# comparar: tiempo tiempo -> int
# entrega -1, 0 o 1 si el primer tiempo es menor, igual o mayor al segundo, respectivamente
# Ej: comparar(tiempo(1,20), tiempo(2,40)) entrega -1 
def comparar(T1, T2):
	assert esTiempo(T1) and esTiempo(T2)
	m1 = enMinutos(T1)
	m2 = enMinutos(T2)
	if m1 > m2:
		return 1
	if m1 == m2:
		return 0
	return -1
	
assert comparar(tiempo(1,20), tiempo(2,40)) == -1
assert comparar(tiempo(2,40), tiempo(1,20)) == 1