import estructura
from tiempo import *

# lista: valor(tiempo) sgte(lista)
estructura.crear("lista", "valor sgte")

# esLista: lista -> bool
# True si L es una lista
# ej esLista(lista(1,None)) es True
def esLista(L):
	#o es una lista tradicional, o es la lista vacia
	return type(L) == lista or L == None
assert esLista(lista(1, None))

# mayorTiempo: lista(tiempo) -> tiempo
# Entrega el mayor tiempo de una lista
# Ej: mayorTiempo(lista(tiempo(1,0), lista(tiempo(2,0), None))) entrega tiempo(2,0)
def mayorTiempo(l):
	assert esLista(l)
	if l == None:
		return tiempo(0,0)
	t1 = l.valor
	t2 = mayorTiempo(l.sgte)
	if comparar(t1, t2) == 1:
		return t1
	else:
		return t2

assert mayorTiempo(lista(tiempo(3,0), lista(tiempo(2,0), None))) == tiempo(3,0)
assert mayorTiempo(lista(tiempo(3,0), lista(tiempo(2,0), lista(tiempo(5,0), None)))) == tiempo(5,0)

# promedioTiempos: lista(tiempo) -> int
# Entrega el promedio en minutos de los tiempos en la lista
# Ej: promedioTiempos(lista(tiempo(1,0), lista(tiempo(12,0), lista(tiempo(10,0), None)))) entrega 460
def promedioTiempos(l, suma=tiempo(0,0), cuenta=0):
	assert esLista(l)
	if l == None:
		return enMinutos(suma)/cuenta
	suma = sumar(suma, l.valor)
	return promedioTiempos(l.sgte, suma, cuenta+1)
	
assert 	promedioTiempos(lista(tiempo(1,0), lista(tiempo(12,0), lista(tiempo(10,0), None)))) == 460

# cuentaMenores: lista(tiempo) tiempo -> int
# Entrega la cantidad de valores de la lista que son menores al tiempo dado
# Ej cuentaMenores(lista(tiempo(5,0), lista(tiempo(2,0), None)), tiempo(3,0)) entrega 1
def cuentaMenores(l, t):
	if l == None:
		return 0
	if comparar(l.valor, t) == -1:
		return 1 + cuentaMenores(l.sgte, t)
	else:
		return cuentaMenores(l.sgte, t)
	
assert 	cuentaMenores(lista(tiempo(5,0), lista(tiempo(2,0), None)), tiempo(3,0)) == 1

# listaMenores: lista(tiempo) tiempo -> lista(tiempo)
# entrega una sublista de l, con los tiempos menores a t
# Ej: listaMenores(lista(tiempo(5,0), lista(tiempo(2,0), None)), tiempo(3,0)) entrega lista(tiempo(2,0), None)
def listaMenores(l, t):
	if l == None:
		return None
	if comparar(l.valor, t) == -1:
		return lista(l.valor, listaMenores(l.sgte, t))
	else:
		return listaMenores(l.sgte, t)
		
assert listaMenores(lista(tiempo(5,0), lista(tiempo(2,0), None)), tiempo(3,0)) == lista(tiempo(2,0), None)