# -*- coding: utf-8 -*-

class Polinomio:
	def __init__(self):
		self.datos = {}
	
	def agregar(self, coeficiente, exponente):
		self.datos[exponente] = coeficiente
	
	def evaluar(self, X):
		resultado = 0
		for exp in self.datos:
			resultado += self.datos[exp] * (X**exp)
		return resultado


class Polinomio1(Polinomio):
	def __init__(self):
		Polinomio.__init__(self)
	
	def derivar(self):
		polinomioResultante = Polinomio1()
		for exp in self.datos:
			if exp != 0:	
				nuevoExpon = exp-1
				nuevoCoef = self.datos[exp]* exp
				polinomioResultante.agregar(nuevoCoef, nuevoExpon)
		return polinomioResultante


# Crear polinomio del enunciado
import math
P = Polinomio1()
P.agregar(1, 0)
P.agregar(-1/math.factorial(2), 2)
P.agregar(1/math.factorial(4), 4)
P.agregar(-1/math.factorial(6), 6)

# esMaximo: num -> bool
# determina si un valor X es máximo del polinomio P
# ej. esMaximo(0) da True
def esMaximo(X):
	d1 = P.derivar()
	cond1 = abs(d1.evaluar(X)) < 0.01
	d2 = P.derivar().derivar()
	cond2 = d2.evaluar(X) < 0
	return cond1 and cond2
	
assert esMaximo(0)
assert not esMaximo(1)
	