import estructura

# lista: valor(tiempo) sgte(lista)
estructura.crear("lista", "valor sgte")

# esLista: lista -> bool
# True si L es una lista
# ej esLista(lista(1,None)) es True
def esLista(L):
	#o es una lista tradicional, o es la lista vacia
	return type(L) == lista or L == None
assert esLista(lista(1, None))


# cabeza: lista(any) -> any
# retorna el primer elemento de la lista
def cabeza(L):
	assert esLista(L)
	return L.valor
	
# cola: lista(any) -> lista(any)
# retorna la lista sin el primer elemento
def cola(L):
	assert esLista(L)
	return L.sgte

#filtro: lista(any) (any any->bool) any -> lista(any)
#lista con valores de L que cumplen comparacion con x
#ej:filtro(lista(5,lista(4,None)),menorQue,5)->lista(4,None)

def filtro(L,comparacion,x):
	assert esLista(L)
	if L==None: 
		return None

	if comparacion(cabeza(L),x):
		return lista(cabeza(L),filtro(cola(L),comparacion,x))

	return filtro(cola(L),comparacion,x)

#mapa: (any->any) lista(any) -> lista(any)
#lista aplicando funcion a valores de L
#ej: mapa(f,lista(5,lista(4,None))) ->
#    lista(f(5),lista(f(4),None))

def mapa(funcion,L):
    assert esLista(L)
    if L==None: return None
    y=funcion(cabeza(L))
    return lista(y,mapa(funcion,cola(L)))

# enLista: any lista(any) -> num
# retorna el lugar en que el elemento se encuentra en la lista, -1 si no esta
# ej. enLista(2, lista(3, lista(2, None))) retorna 1
def enLista(x, L, i=0):
	assert esLista(L)
	if L == None: return -1
	if x == cabeza(L): return i
	return enLista(x, cola(L), i+1)
assert enLista(2, lista(3, lista(2, None))) == 1
	
# apariciones: any lista(any) -> lista(num)
# entrega una lista con todas las apariciones de x en la lista
# ej. apariciones(1, lista(1, lista(2, lista(1, None)))) entrega lista(0, lista(2, None))
def apariciones(x, L, i=0):
	assert esLista(L)
	if L == None: return None
	if x == cabeza(L): return lista(i, apariciones(x, cola(L), i+1))
	return apariciones(x, cola(L), i+1)
assert apariciones(1, lista(1, lista(2, lista(1, None)))) == lista(0, lista(2, None))

# insertarFinal: any list(any) -> list(any)
# agrega un elemento al final de la lista
# ej. insertarFinal(2, lista(1, lista(3, None))) entrega lista(1, lista(3, lista(2, None)))
def insertarFinal(x, L):
	assert esLista(L)
	if L is None: return lista(x, None)
	return lista(cabeza(L), insertarFinal(x, cola(L)))
assert insertarFinal(2, lista(1, lista(3, None))) == lista(1, lista(3, lista(2, None)))

# invertir: lista(any) -> lista(any)
# entrega la lista con los elementos invertidos
# Ej: invertir(lista(3,lista(2,lista(1,None)))  debe entregar lista(1,lista(2,lista(3,None)))
def invertir(L):
	assert esLista(L)
	if L==None: return None
	return insertarFinal(cabeza(L), invertir(cola(L)))
assert invertir(lista(3,lista(2,lista(1,None)))) == lista(1,lista(2,lista(3,None)))

#pares: lista(num) -> lista(num)
# entrega una lista solo con los numeros pares de la lista
# ej. pares(lista(2, lista(3, lista(4, None)))) entrega lista(2, lista(4, None))
def pares(L):
	assert esLista(L)
	if L is None: return None
	if cabeza(L) % 2 == 0: return lista(cabeza(L), pares(cola(L)))
	return pares(cola(L))
assert pares(lista(2, lista(3, lista(4, None)))) == lista(2, lista(4, None))

# esDivisible: num -> bool
# dice si el numero es divisible por el otro o no
# ej. esDivisible(2,2) es True, esDivisible(7,2) es False
def esDivisible(n, d):
	return n%d == 0
assert esDivisible(2,2) and not esDivisible(7,2)

#paresFiltro: lista(num) -> lista(num)
# entrega una lista solo con los numeros pares de la lista usando filtro
# ej. paresFiltro(lista(2, lista(3, lista(4, None)))) entrega lista(2, lista(4, None))
def paresFiltro(L):
	assert esLista(L)
	return filtro(L, esDivisible, 2)
assert paresFiltro(lista(2, lista(3, lista(4, None)))) == lista(2, lista(4, None))

#binario: lista(num) -> lista(bin)
#retorna una lista con la representacion binaria de los numeros de la lista
#ej. binario(lista(2, lista(4, None))) entrega lista('0b10', lista('0b100', None))
def binario(L):
	assert esLista(L)
	if L==None: return None
	return lista(bin(cabeza(L)), binario(cola(L)))
assert binario(lista(2, lista(4, None))) == lista('0b10', lista('0b100', None))

#binarioMapa: lista(num) -> lista(bin)
#retorna una lista con la representacion binaria de los numeros de la lista
#ej. binario(lista(2, lista(4, None))) entrega lista('0b10', lista('0b100', None))
def binarioMapa(L):
	assert esLista(L)
	return mapa(bin, L)
assert binarioMapa(lista(2, lista(4, None))) == lista('0b10', lista('0b100', None))