# -*- coding: utf-8 -*-

class Conjunto:
	def __init__(self, x=None, y=None):
		self.lista = []
		if x != None:
			if y != None:
				for valor in range(x,y+1):
					self.lista.append(valor)
			else:
				self.lista.append(x)

	def __eq__(self, c2):
		if len(self.lista) != len(c2.lista):
			return False
		else:
			for valor in self.lista:
				if valor not in c2.lista:
					return False
			return True

	def __ne__(self, c2):
		return not self == c2	

	def extraerMenor(self):
		if len(self.lista) == 0:
			return None
		else:
			m = min(self.lista)
			self.lista.remove(m)
			return m

	def __add__(self, c2):
		salida = Conjunto()
		for valor in self.lista:
			if not valor in c2.lista:
				salida.lista.append(valor)
		for valor in c2.lista:
			if not valor in self.lista:
				salida.lista.append(valor)
		return salida


	def contiene(self, valor):
		return valor in self.lista

	def __sub__(self, c2):
		salida = Conjunto()
		for valor in self.lista:
			if valor not in c2.lista:
				salida.lista.append(valor)
		return salida

	def __str__(self):
		texto = "{"
		for i in range(len(self.lista)-1):
			texto = texto + str(self.lista[i]) + ","
		texto = texto + str(self.lista[len(self.lista)-1]) + "}"
		return texto


N = 78
primos=Conjunto(1)
criba=Conjunto(2,N)
vacio=Conjunto()

while criba!=vacio:
	m = criba.extraerMenor()
	primos = primos+Conjunto(m)
	for i in range(m, N+1, m):
		if criba.contiene(i):  
			criba = criba - Conjunto(i)

print str(primos)