# -*- coding: utf-8 -*-

import random

class YaExiste(Exception):
	def __init__(self):
		print "ya estaba en el conjunto"

class BolsaVacia(Exception):
	def __init__(self):
		print "La bolsa no tiene elementos"

class Bolsa:
	def __init__(self):
		self.contenedor = []

	def poner(self, x):
		if x in self.contenedor:
			raise YaExiste()
		else:
			self.contenedor.append(x)

	def sacar(self):
		largo = len(self.contenedor)
		if largo == 0:
			raise BolsaVacia()
		else:
			indice = random.randint(0, largo-1)
			return self.contenedor.pop(indice)


numeros = []
b = Bolsa()

for i in range(10):
	numeros.append(random.randint(1,10))

print numeros

for valor in numeros:
	try:
		b.poner(valor)
	except YaExiste:
		pass

print b.contenedor