# -*- coding: utf-8 -*-

class Tiempo:
	def __init__(self, x, y=0):
		if type(x) == str:
			i = x.find(":")
			self.__horas = int(x[0:i])
			self.__minutos = int(x[i+1:len(x)])
		else:
			self.__horas = x
			self.__minutos = y

	def __add__(self, t2):
		minutos = (self.__minutos + t2.minutos())%60
		horas = (self.__minutos + t2.minutos())/60 + self.__horas
		return Tiempo(horas, minutos)

	def __sub__(self, t2):
		total = self.minutos() - t2.minutos()
		minutos = abs(total)%60
		horas = total/60
		return Tiempo(horas, minutos)

	def __gt__(self, t2):
		return self.minutos() > t2.minutos()

	def __str__(self):
		if self.__minutos < 10:
			minutos = "0"+str(self.__minutos)
		else:
			minutos = str(self.__minutos)
		return str(self.__horas)+":"+minutos

	def minutos(self):
		return self.__minutos + self.__horas*60


t1 = Tiempo(raw_input("Ingrese primer instante (HH:MM) ? "))
t2 = Tiempo(raw_input("Ingrese segundo instante (HH:MM) ? "))
print "Suma =", t1+t2
print "Diferencia =", t1-t2
if t1 > t2:
	print "Mayor =", t1
else:
	print "Mayor =", t2