# -*- coding: utf-8 -*-

import estructura
estructura.crear("ABB","valor izq der")
 

miPrimerABB = ABB(3, ABB(2, ABB(1, None, None), None), ABB(5, ABB(4, None, None), None))
miSegundoABB = ABB(2, ABB(1, None, None), None)
miTercerABB = ABB(7, ABB(6, None, None), None)

def esArbol(A):
	return A==None or type(A)==ABB


# enABB: any ABB -> bool
# entrega True si un valor pertenece a un conjunto
# ej. enABB(1, miPrimerABB) da True
def enABB(x,A):
    assert esArbol(A)
    if A==None:
		return False
    elif x<A.valor:
		return enABB(x,A.izq)
    elif x>A.valor:
		return enABB(x,A.der)
    else:
		return True
assert enABB(1, miPrimerABB)
assert enABB(3, miPrimerABB)
assert not enABB(9, miPrimerABB)
assert enABB(2, miPrimerABB)
assert not enABB(6, miPrimerABB)

# esSubconjunto: ABB ABB -> ABB
# recibe dos conjuntos y entrega True si el primero es subconjunto del segundo
# ej esSubconjunto(miSegundoABB, miPrimerABB) da True
def esSubconjunto(A, B):
	assert esArbol(A) and esArbol(B)
	if A == None:
		return True
	else:
		return enABB(A.valor, B) and esSubconjunto(A.der, B) and esSubconjunto(A.izq, B)
assert esSubconjunto(miSegundoABB, miPrimerABB)
assert not esSubconjunto(miPrimerABB, miSegundoABB)
assert not esSubconjunto(miTercerABB, miPrimerABB)
assert esSubconjunto(None, miTercerABB)


#insertar: any ABB -> ABB
#nuevo ABB insertando x en A
#ej: insertar("A",ABB("B",None,None))->
#                 ABB("B",ABB("A",None,None),None)
def insertar(x,A):
	assert esArbol(A)
	if A==None: 
		return ABB(x,None,None)
	v=A.valor
	if x==v:
		return A
	if x<v:
		return ABB(v, insertar(x,A.izq), A.der)
	if x>v:
		return ABB(v, A.izq, insertar(x,A.der) )
assert insertar("A",ABB("B",None,None))== ABB("B",ABB("A",None,None),None)


# union: ABB ABB -> ABB
# recibe dos conjuntos y entrega la union
def union(A, B):
	assert esArbol(A) and esArbol(B)
	if A==None:
		return B
	else:
		B2 = union(A.izq, B)
		B3 = union(A.der, B2)
		return insertar(A.valor, B3)
assert union(ABB(3,None,None), miSegundoABB) == ABB(2, ABB(1, None, None), ABB(3, None, None))

print miPrimerABB
print miTercerABB
print 
print union(miPrimerABB, miTercerABB)
print
print union(miTercerABB, miPrimerABB)