# -*- coding: utf-8 -*-

from lista import *
from funciones import *


# Para tests
l1 = lista(1, lista(2, lista(3, None)))
l2 = lista(3, lista(2, lista(1, None)))
l3 = lista(1, lista(3, lista(2, None)))

# eliminarPrimero: lista(any) any -> lista(any)
# reciba una lista y un valor y entregue una lista sin la primera aparición del valor v
# ej. eliminarPrimero(l1, 1) da lista(2, lista(3, None))
def eliminarPrimero(L, v):
	assert esLista(L)
	if L==None:
		return L
	elif cabeza(L) == v:
		return cola(L)
	else:
		return lista(cabeza(L), eliminarPrimero(cola(L), v))

assert eliminarPrimero(l1, 1) == lista(2, lista(3, None))
assert eliminarPrimero(l1, 2) == lista(1, lista(3, None))
assert eliminarPrimero(l3, 3) == lista(1, lista(2, None))
	
# minimo: num num -> num
# retorna el menor entre dos numeros
# ej. minimo(2,3) da 2
def minimo(a,b):
	return min(a,b)
assert minimo(1,2) == 1
assert minimo(0,2) == 0


# menor: lista(num) -> num
# reciba una lista y entregue el menor valor de la lista
# ej. menor(l1) da 1
def menor(L):
	assert esLista(L)
	if cola(L) == None:
		return cabeza(L)
	else:
		return reductor(minimo, cabeza(L), cola(L))

assert menor(l1) == 1
assert menor(l2) == 1
assert menor(l3) == 1

	
# seleccion: lista(num)	-> lista(num)
# recibe una lista y entregue otra lista con los elementos ordenados usando selecciòn
# ej. seleccion(l2) da l1
def seleccion(L):
	assert esLista(L)
	valorMenor = menor(L)
	valoresRestantes = eliminarPrimero(L, valorMenor)
	if valoresRestantes == None:
		return lista(valorMenor, None)
	else:
		return lista(valorMenor, seleccion(valoresRestantes))
	
assert seleccion(l1) == l1
assert seleccion(l2) == l1
assert seleccion(l3) == l1

	
	