# -*- coding: utf-8 -*-

from lista import *

#filtro: lista(any) (any any->bool) any -> lista(any)
#lista con valores de L que cumplen comparacion con x
#ej:filtro(lista(5,lista(4,None)), lambda x,y: x<y,5) –>
#   lista(4,None)

def filtro(L,comparacion,x):
	assert esLista(L)
	if L==None: 
		return None
	if comparacion(cabeza(L),x):
		return lista(cabeza(L),filtro(cola(L),comparacion,x))
	return filtro(cola(L),comparacion,x)


#mapa: (any->any) lista(any) -> lista(any)
#lista aplicando funcion a valores de L
#ej: mapa(esPrimo,lista(3,lista(6,None))) ->
#    lista(True,lista(False,None))

def mapa(funcion,L):
	assert esLista(L)
	if L==None:
		return None
	y=funcion(cabeza(L))
	return lista(y,mapa(funcion,cola(L)))

	
	
#reductor: (any any->any) any lista -> any
#reducir L a un solo valor aplicando funcion f
def reductor(f,x,L):
	assert type(L)==lista
	y=f(cabeza(L),x)
	if cola(L) == None:
		return y
	else:
		return reductor(f,y,cola(L))
