# -*- coding: utf-8 -*-

import estructura
from p1 import *

miheap = Nodo(2, Nodo(5,Nodo(7,None,None),Nodo(8,None,None)), Nodo(3,Nodo(6,None,None),None))

# esMenor: Nodo Nodo -> bool	
# dice si el valor del primer nodo es menor que el del segundo
def esMenor(a, b):
	assert esNodo(a) and esNodo(b) and a != None
	if b == None:
		return True
	else:
		return a.valor < b.valor


# esHeap: Nodo -> bool
# dice si el arbol cumple condicion de heap
# ej. esHeap(miheap) entrega True
def esHeap(a):
	assert esNodo(a)
	if a is None:
		return True
	elif esMenor(a, a.izq) and esMenor(a, a.der):
		return esHeap(a.izq) and esHeap(a.der)
	else:
		return False
assert esHeap(miheap)


# menor: Nodo -> int
# entrega el menor valor del heap
# ej. menor(miheap) entrega 2
def menor(a):
	assert esHeap(a)
	if a == None:
		return -1
	else:
		return a.valor
assert menor(A) == 2


# agregar: int heap -> heap
# agrega un valor al heap
# ej. agregar(4, A) entrega Nodo(2, Nodo(5,Nodo(7,None,None),Nodo(8,None,None)), Nodo(3,Nodo(6,None,None),Nodo(4, None, None))
def agregar(val, heap):
	assert type(val) == int and esHeap(heap)
	if heap == None:
		return Nodo(val, None, None)
	else:
		izq = tamano(heap.izq)
		der = tamano(heap.der)
		if heap.val > val:
			aux = heap.val
			if izq < der:
				return Nodo(val, agregar(aux, heap.izq), heap.der)
			else:
				return Nodo(val, heap.izq, agregar(aux, heap.der))
		elif izq < der:
			return Nodo(heap.val, agregar(val, heap.izq), heap.der)
		else:
			return Nodo(heap.val, heap.izq, agregar(val, heap.der))


# elimina el menor elemento de un heap
# ej. borrarMenor(A) = Nodo(3, Nodo(5, Nodo(7, None, None), Nodo(8, None, None)), Nodo(6, None, None))
def borrarMenor(heap):
	assert esHeap(heap)
	if heap == None:
		return None
	elif heap.izq == None and heap.der == None: 
		return None
	elif heap.izq == None: 
		return heap.der
	elif heap.der == None: 
		return heap.izq
	elif heap.izq.valor < heap.der.valor:
		return Nodo(heap.izq.valor, borrarMenor(heap.izq), heap.der)
	else:
		return Nodo(heap.der.valor, heap.izq, borrarMenor(heap.der))








#  HEAPSORT

from lista import *

L = lista(2,lista(5,lista(3,lista(7,lista(8,lista(6,None))))))
S = lista(2,lista(3,lista(5,lista(6,lista(7,lista(8,None))))))

# agregarTodos: lista -> heap
# entrega un heap con todos los elementos de la lista
def agregarTodos(l, heap = None):
	assert esLista(l)
	if l == None: 
		return heap
	else:
		return agregarTodos(l.sgte, agregar(l.valor, heap))
assert agregarTodos(L) == Nodo(2,Nodo(5,Nodo(7,None,None),Nodo(8,None,None)),Nodo(3,Nodo(6,None,None),None))

#quitarTodos: heap -> lista
#entrega una lista, quitando todos los elementos del heap
# ej. quitarTodos(agregarTodos(L)) es S
def quitarTodos(heap):
	assert esHeap(heap)
	if heap == None:
		return None
	else:
		return lista(menor(heap), quitarTodos(borrarMenor(heap)))
assert quitarTodos(agregarTodos(L)) == S

#heapsort: lista -> lista
# dada una lista, entrega otra con los elementos ordenados
# ej. heapsort(L) = S
def heapsort(l):
	assert esLista(l)
	return quitarTodos(agregarTodos(l))
assert heapsort(L) == S