# -*- coding: utf-8 -*-

import estructura
from p1 import *

# Estructura

# lista: valor(Tiempo) sgte(lista)
estructura.crear("lista", "valor sgte")

# esLista: lista(any) -> bool
# verifica que L sea de tipo lista
# ej esLista(lista(1, None)) da True
def esLista(L):
	return type(L) == lista or L == None

assert esLista(lista(1, None))
assert not esLista(3)


# Funciones

# mayorTiempo: lista(Tiempo) -> Tiempo
# Entrega el mayor tiempo de la lista L
# Ej. mayorTiempo(lista(Tiempo(1,1)), lista(Tiempo(2,5), lista(Tiempo(0,49), None)))
# Cuerpo
def mayorTiempo(L):
	assert esLista(L) and esTiempo(L.valor)
	if L.sgte == None:
		return L.valor
	else:
		return max(L.valor, mayorTiempo(L.sgte))
# Tests
assert mayorTiempo(lista(Tiempo(1,1), lista(Tiempo(0,49), None))) == Tiempo(1,1)
assert mayorTiempo(lista(Tiempo(10,10), None)) == Tiempo(10,10)
assert mayorTiempo(lista(Tiempo(1,1), lista(Tiempo(2,5), lista(Tiempo(0,49), None)))) == Tiempo(2,5)


# promedioTiempos: lista(Tiempo) -> float
# Entrega el promedio en minutos de la lista L
# Ej.promedioTiempos(lista(Tiempo(1,1), lista(Tiempo(0,49), None))) da 55
# Cuerpo
def promedioTiempos(L, suma=0, elementos=0):
	assert esLista(L)
	if L == None:
		return 1.0*suma/elementos
	else:
		suma=enMinutos(L.valor) + suma
		elementos = elementos + 1
		return promedioTiempos(L.sgte, suma, elementos)

# Tests
assert promedioTiempos(lista(Tiempo(1,1), lista(Tiempo(0,49), None))) == 55
assert promedioTiempos(lista(Tiempo(1,10), None)) == 70
assert promedioTiempos(lista(Tiempo(0,10), lista(Tiempo(1,1), lista(Tiempo(0,49), None)))) == 40


# cuentaMenores: lista(Tiempo) Tiempo -> int
# Entrega la cantidad de  tiempos de la lista L menores al tiempo T
# Ej. cuentaMenores(lista(Tiempo(1,1), lista(Tiempo(0,49), None)), Tiempo(0,50)) da 1
# Cuerpo
def cuentaMenores(L, T):
	assert esLista(L) and type(T) == Tiempo
	if L.sgte == None:
		if comparar(L.valor, T) == -1:
			return 1
		else:
			return 0
	else:
		if comparar(L.valor, T) == -1:
			return 1 + cuentaMenores(L.sgte, T)
		else:
			return 0 + cuentaMenores(L.sgte, T)
# Tests
assert cuentaMenores(lista(Tiempo(1,1), lista(Tiempo(0,49), None)), Tiempo(0,50)) == 1
assert cuentaMenores(lista(Tiempo(1,10), None), Tiempo(1,1)) == 0
assert cuentaMenores(lista(Tiempo(0,10), lista(Tiempo(1,1), lista(Tiempo(0,49), None))), Tiempo(100,20)) == 3


# listaMenores: lista(Tiempo) -> lista(Tiempo)
# Entrega una lista con los tiempos de la lista L menores al tiempo T
# Ej. listaMenores(lista(Tiempo(1,10), None), Tiempo(1,1)) da None
# Cuerpo
def listaMenores(L, T):
	assert esLista(L) and type(T) == Tiempo
	if L.sgte == None:
		if comparar(L.valor, T) == -1:
			return lista(L.valor, None)
		else:
			return None
	else:
		if comparar(L.valor, T) == -1:
			return lista(L.valor, listaMenores(L.sgte, T))
		else:
			return listaMenores(L.sgte, T)
# Tests
assert listaMenores(lista(Tiempo(1,1), lista(Tiempo(0,49), None)), Tiempo(0,50)) == lista(Tiempo(0,49), None)
assert listaMenores(lista(Tiempo(1,10), None), Tiempo(1,1)) == None
assert listaMenores(lista(Tiempo(0,10), lista(Tiempo(1,1), lista(Tiempo(0,49), None))), Tiempo(100,20)) == lista(Tiempo(0,10), lista(Tiempo(1,1), lista(Tiempo(0,49), None))), Tiempo(100,20)