# -*- coding: utf-8 -*-

import estructura

# Estructura

# Tiempo: horas (int) minutos (int)
estructura.crear("Tiempo", "horas minutos")

# esTiempo: Tiempo -> bool
# Valida que sea un instante de tiempo valido
# ej: esTiempo(tiempo(10,45)) es True
def esTiempo(T):
	assert type(T) == Tiempo
	assert type(T.horas) == int and type(T.minutos) == int
	return 0 <= T.minutos < 60 and T.horas >= 0
#Test
assert esTiempo(Tiempo(10, 45))

# Funciones

# aString: Tiempo -> str
# Entrega el tiempo en la forma ”HH:MM”
# Ej. aString(Tiempo(12,45)) da '12:45'
# Cuerpo
def aString(tiempo):
	assert esTiempo(tiempo)
	if tiempo.horas < 10:
		strHoras = "0"+str(tiempo.horas)
	else:
		strHoras = str(tiempo.horas)
		
	if tiempo.minutos < 10:
		strMinutos = "0"+str(tiempo.minutos)
	else:
		strMinutos = str(tiempo.minutos)
	
	return strHoras+":"+strMinutos
# Tests
assert aString(Tiempo(12,45)) == "12:45"
assert aString(Tiempo(1,20)) == "01:20"
assert aString(Tiempo(0,5)) == "00:05"


# enMinutos: Tiempo -> int
# Entrega un int que equivale al tiempo expresado únicamente en minutos.
# Ej. enMinutos(Tiempo(1,12)) da 72
def enMinutos(tiempo):
	assert esTiempo(tiempo)
	return tiempo.minutos + tiempo.horas*60
# Tests
assert enMinutos(Tiempo(12,45)) == 765
assert enMinutos(Tiempo(1,20)) == 80
assert enMinutos(Tiempo(0,5)) == 5


# sumar: Tiempo Tiempo -> Tiempo
# Para sumar dos tiempos
# Ej. sumar(Tiempo(1,23), Tiempo(0, 12)) da Tiempo(1,35)
def sumar(t1, t2):
	assert esTiempo(t1) and esTiempo(t2)
	totalMinutos = enMinutos(t1) + enMinutos(t2)
	minutos = totalMinutos%60
	horas = totalMinutos/60
	return Tiempo(horas, minutos)
	
# Tests
assert sumar(Tiempo(1,23), Tiempo(0, 12)) == Tiempo(1,35)
assert sumar(Tiempo(0,3), Tiempo(1, 0)) == Tiempo(1,3)
assert sumar(Tiempo(0,1), Tiempo(0, 59)) == Tiempo(1,0)
assert sumar(Tiempo(0,2), Tiempo(0, 59)) == Tiempo(1,1)


# restar: Tiempo Tiempo -> Tiempo
# Para restar dos tiempos
# Ej. restar(Tiempo(1,23), Tiempo(0, 12)) da Tiempo(1,11)
def restar(t1, t2):
	assert type(t1) == Tiempo and type(t2) == Tiempo
	assert enMinutos(t1) >= enMinutos(t2)
	totalMinutos = enMinutos(t1) - enMinutos(t2)
	minutos = totalMinutos%60
	horas = totalMinutos/60
	return Tiempo(horas, minutos)
# Tests
assert restar(Tiempo(1,23), Tiempo(0, 12)) == Tiempo(1,11)
assert restar(Tiempo(0,59), Tiempo(0, 59)) == Tiempo(0,0)
assert restar(Tiempo(1,0), Tiempo(0, 1)) == Tiempo(0,59)

# comparar: Tiempo Tiempo -> Tiempo
# Que entrega -1, 0, ó 1 en caso que el primer tiempo  sea menor, igual o mayor que el segundo tiempo, respectivamente
# Ej. comparar(Tiempo(1,23), Tiempo(0, 12)) da 1
def comparar(t1, t2):
	assert type(t1) == Tiempo and type(t2) == Tiempo
	if enMinutos(t1) < enMinutos(t2):
		return -1
	elif enMinutos(t1) == enMinutos(t2):
		return 0
	else:
		return 1
# Tests
assert comparar(Tiempo(1,23), Tiempo(0, 12)) == 1
assert comparar(Tiempo(0,3), Tiempo(1, 0)) == -1
assert comparar(Tiempo(0,59), Tiempo(0, 59)) == 0
assert comparar(Tiempo(0,2), Tiempo(0, 59)) == -1