 # -*- coding: utf-8 -*-

# pertenece: num num num -> bool
# Recibe valores numéricos x, y , z y retorna True si x pertenece al intervalo [y,z] o False de lo contrario
# Ejemplo: pertenece(2,1,4) retorna True
def pertenece(x,y,z):
	return x >= y and x <= z

assert pertenece(1,2,3) == False
assert pertenece(3,1,2) == False
assert pertenece(2,1,3) == True
assert pertenece(1,1,3) == True
assert pertenece(1,1,1) == True

# piedraPapelTijeras: int -> str
# Recibe un entero entre 1 y 3 y retorna la jugada correspondiente
# 1 <--> piedra, 2 <--> papel, 3 <--> tijeras
# Ejemplo: piedraPapelTijeras(2) retorna 'papel'
def piedraPapelTijeras(x):
	if x == 1: return 'piedra'
	elif x == 2: return 'papel'
	elif x == 3: return 'tijeras'

assert piedraPapelTijeras(1) == 'piedra'
assert piedraPapelTijeras(2) == 'papel'
assert piedraPapelTijeras(3) == 'tijeras'

# ganador: int int -> int
# Recibe las jugadas de dos jugadores como números entre 1 y 3 entrega: 0 si hubo empate, 1 si gana el jugador "x" o 2 si gana el jugador "y"
# Ejemplo: ganador(1,1) da 0
def ganador(x,y):
	if x == 1: # Jugador 1 jugó piedra
		if y == 1: # Jugador 2 jugó piedra, empate
			return 0
		elif y == 2: # Jugador 2 jugó papel, gana jugador 2
			return 2
		else: # Jugador 2 jugó tijeras, gana jugador 1
			return 1
	elif x == 2: # Jugador 1 jugó papel
		if y == 1: # Jugador 2 jugó piedra, gana jugador 1
			return 1
		elif y == 2: # Jugador 2 jugó papel, empate
			return 0
		else: # Jugador 2 jugó tijeras, gana jugador 2
			return 2
	else: # Jugador 1 jugó tijeras
		if y == 1: # Jugador 2 jugó piedra, gana jugador 2
			return 2
		elif y == 2: # Jugador 2 jugó papel, gana jugador 1
			return 1
		else: # Jugador 2 jugó tijeras, empate
			return 0

assert ganador(1,1) == 0
assert ganador(1,2) == 2
assert ganador(1,3) == 1
assert ganador(2,1) == 1
assert ganador(2,2) == 0
assert ganador(2,3) == 2
assert ganador(3,1) == 2
assert ganador(3,2) == 1
assert ganador(3,3) == 0

