#!/usr/local/bin/python
# -*- coding: utf-8 -*-

# metros_a_kilom: num -> float
# Recibe un número que representa una distancia en metros y retorna un float que representa la misma distancia en kilometros
# Ejemplo: metros_a_kilom(345) retorna 0.345
def metros_a_kilom(metros):
	return metros / 1000.0

assert metros_a_kilom(1000)==1.0
assert metros_a_kilom(345.3)==0.3453
assert metros_a_kilom(2300)==2.3

# segundos_a_horas: num -> float
# Recibe un número que representa un tiempo en segundos y retorna un float que representa el mismo tiempo en horas
def segundos_a_horas(segundos):
	return segundos / 3600.0

assert segundos_a_horas(3600) == 1.0
assert segundos_a_horas(1800) == 0.5
assert segundos_a_horas(7200) == 2.0

# velocidad_en_KMH: num num -> num
# Recibe dos números que representan una distancia en metros y un tiempo en segundos, y retorna la velocidad correspondiente en Kilometros por hora
# Ejemplo: velocidad_en_KMH(1000, 3600) retorna 1.0
def velocidad_en_KMH(metros, segundos):
	kilometros = metros_a_kilom(metros)
	horas = segundos_a_horas(segundos)
	return kilometros / horas

assert velocidad_en_KMH(1000, 3600)==1.0
assert velocidad_en_KMH(500, 3600)==0.5
assert velocidad_en_KMH(20, 10)==7.2
