import pygame
import math
import random
from constantes import *

class Pelota:
	def __init__(self,x,y,width,height):
		self.x = x
		self.y = y
		self.width = width
		self.height = height

		#El color del rectangulo
		self.color = (255,255,255)
		#el grosor de la line, thickness 0, rellena el rectangulo
		self.thickness = 0
		#vector direccion de la velocidad
		self.velocX = 0.25
		self.velocY = 0.25
		self.rapidez = 0.3

	def mover(self,dt):
		# notar que pasamos la diferencia de tiempo
		w = self.width/2
		h = self.height/2
		#normalizamos el vector direccion
		d = math.sqrt(self.velocX**2+self.velocY**2)
		self.velocX /= d
		self.velocY /= d

		#colision con bordes de pantalla
		#arriba o abajo
		if self.y+h <= 0:
			self.velocY *= -1
			self.y = h
		if self.y-h>=SCREEN_HEIGHT:
			self.velocY *= -1
			self.y = SCREEN_HEIGHT-h
		#izquierda o derecha
		(colisonIZQ,colisionDER) = (self.x + w <= 0, self.x-h>=SCREEN_WIDTH)
		if colisonIZQ or colisionDER:
			self.velocX *= -1
			return (colisonIZQ,colisionDER)
		else:
			#actualizamos la posicion
			self.x += self.velocX*self.rapidez*dt
			self.y += self.velocY*self.rapidez*dt
			return (False,False)

	def dibujar(self,screen):
		#dibujar el rectangulo
		w = self.width/2
		h = self.height/2
		pygame.draw.rect(screen, self.color, (self.x-w,self.y-h,self.width,self.height), self.thickness)

	def getRectangulo(self):
		w = self.width/2
		h = self.height/2
		return (self.x-w,self.y-h,self.x+w,self.y+h)

	def resetPos(self):
		r = 1.0/random.randint(2,10)
		i = -1 if random.randint(1,10)%2==0 else 1
		self.velocX = (1-r)*-i
		self.velocY = r*i
		self.x = SCREEN_WIDTH/2
		self.y = SCREEN_HEIGHT/2

	def chocarIZQ(self):
		self.x += self.width/2 + 1
		self.velocX *= -1

	def chocarDER(self):
		self.x -= self.width/2 + 1
		self.velocX *= -1
