import pygame
from constantes import *

class Paleta:
	def __init__(self,x,y,width,height):
		self.x = x
		self.y = y
		self.width = width
		self.height = height

		#El color del rectangulo
		self.color = (255,255,255)
		#el grosor de la line, thickness 0, rellena el rectangulo
		self.thickness = 0

	def mover(self,distancia):
		#notar que le pasamos la distancia que va a recorrer
		
		# la paleta llego al techo
		h = self.height/2
		if self.y < TOP_PALETA + h and distancia > 0:
			return
		# la paleta llego al suelo
		elif self.y > BOTTOM_PALETA - h and distancia < 0:
			return
		else:
			self.y -= distancia

	def dibujar(self,screen):
		#dibujar el rectangulo
		w = self.width/2
		h = self.height/2
		pygame.draw.rect(screen, self.color, (self.x-w,self.y-h,self.width,self.height), self.thickness)

	def getRectangulo(self):
		w = self.width/2
		h = self.height/2
		return (self.x-w,self.y-h,self.x+w,self.y+h)
