from constantes import *
from Pelota import *
from Paleta import *

def rectanguloSobrepuesto((a_min_x,a_min_y,a_max_x,a_max_y),(b_min_x,b_min_y,b_max_x,b_max_y)):
	return a_max_x > b_min_x and b_max_x > a_min_x and a_max_y > b_min_y and b_max_y > a_min_y

#==============MODELO==================
class Modelo:
	def __init__(self):
		#inicializamos el modelo
		self.paleta1 = Paleta(50,SCREEN_HEIGHT/2,50,100)
		self.paleta2 = Paleta(SCREEN_WIDTH - 50,SCREEN_HEIGHT/2,50,100)
		self.pelota = Pelota(SCREEN_WIDTH/2,SCREEN_HEIGHT/2,25,25)
		self.scoreP1 = 0
		self.scoreP2 = 0

	def moverPaleta1(self,distancia):
		self.paleta1.mover(distancia)

	def moverPaleta2(self,distancia):
		self.paleta2.mover(distancia)

	def moverPelota(self,dt):
		(colisonIZQ,colisionDER) = self.pelota.mover(dt)
		if colisonIZQ:
			self.scoreP2 += 1
		if colisionDER:
			self.scoreP1 += 1
		if any((colisonIZQ,colisionDER)):
			print ("PONG | Score: P1 %d - P2 %d" % (self.scoreP1,self.scoreP2))
			self.pelota.resetPos()

	def dibujar(self,screen):
		#dibujamos el modelo
		self.paleta1.dibujar(screen)
		self.paleta2.dibujar(screen)
		self.pelota.dibujar(screen)

	def chequearColision(self):
		rectPaleta1 = self.paleta1.getRectangulo()
		rectPaleta2 = self.paleta2.getRectangulo()
		rectPelota = self.pelota.getRectangulo()

		if rectanguloSobrepuesto(rectPaleta1,rectPelota):
			self.pelota.chocarIZQ()
		if rectanguloSobrepuesto(rectPaleta2,rectPelota):
			self.pelota.chocarDER()