import pygame
from pygame.locals import *

#==============CONTROLADOR=============
class Controlador:
	def __init__(self,modelo):
		self.modelo = modelo
		self.t = pygame.time.get_ticks()
		self.GAMEOVER = False

		self.hold_w = self.hold_s = self.hold_o = self.hold_l = self.hold_mouse = False

	def actualizarModelo(self):
		#actualizamos el valor del tiempo y calculamos la diferencia entre llamados
		tiempoActual = pygame.time.get_ticks()
		dt = tiempoActual - self.t
		self.t = tiempoActual

		# Tomamos informacion sobre el input
		(mouseX,mouseY) = pygame.mouse.get_pos()
		(dX,dY) = pygame.mouse.get_rel()

		for event in pygame.event.get():
			if event.type == pygame.QUIT:
				self.GAMEOVER = True
			if event.type == KEYDOWN:
				if event.key == K_ESCAPE:
					self.GAMEOVER = True
				if event.key == K_w:
					self.hold_w = True
				if event.key == K_s:
					self.hold_s = True
				if event.key == K_o:
					self.hold_o = True
				if event.key == K_l:
					self.hold_l = True
			if event.type == KEYUP:
				if event.key == K_w:
					self.hold_w = False
				if event.key == K_s:
					self.hold_s = False
				if event.key == K_o:
					self.hold_o = False
				if event.key == K_l:
					self.hold_l = False
			if event.type == MOUSEBUTTONDOWN:
				self.hold_mouse = True
			if event.type == MOUSEBUTTONUP:
				self.hold_mouse = False
		
		if self.hold_w:
			self.modelo.moverPaleta1(2)
		if self.hold_s:
			self.modelo.moverPaleta1(-2)
		if self.hold_o:
			self.modelo.moverPaleta2(2)
		if self.hold_l:
			self.modelo.moverPaleta2(-2)

		self.modelo.moverPelota(dt)

		self.modelo.chequearColision()

	def chequearGameOver(self):
		return not self.GAMEOVER