/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.validator;

import edu.csus.ecs.pc2.VersionInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;

public class Validator {
    private String inputFileName;
    private String outputFileName;
    private String answerFileName;
    private String resultFileName;
    private String pc2Option = "1";
    private boolean ignoreCaseFlag = false;
    public static final String JUDGEMENT_YES = "accepted";
    public static final String JUDGEMENT_NO_PRESENTATION_ERROR = "No - Presentation Error";
    public static final String JUDGEMENT_NO_WRONG_ANSWER = "No - Wrong Answer";
    public static final String JUDGEMENT_NO_INDETERMINANT = "No - Indeterminant";
    private String extraValidatorDifference = "";
    private boolean debugFlag = false;
    private boolean allowFatalExit = true;
    private boolean verbose = false;
    private static final String REGULAR_DIFF = "1";
    private static final String IGNORE_WHITESPACE_HEAD = "2";
    private static final String IGNORE_ALL_WHITESPACE = "4";
    private static final String IGNORE_EMPTY_LINES = "5";

    private void usage() {
        VersionInfo vi = new VersionInfo();
        System.out.println("Usage: java Validator [options] <inputfile name> <outputfile name> <answerfile name> <resultfile name> <-pc2> [pc2_option] icflag");
        System.out.println();
        System.out.println("Where: ");
        System.out.println("pc2 options are: ");
        System.out.println("1 - diff");
        System.out.println("2 - ignore whitespace at start of file");
        System.out.println("3 - ignore leading whitespace on lines");
        System.out.println("4 - ignore all whitespace on lines");
        System.out.println("5 - ignore empty lines");
        System.out.println("6   2 & 3");
        System.out.println("7   2 & 4");
        System.out.println("8   2 & 5");
        System.out.println("9   3 & 5");
        System.out.println("10  4 & 5");
        System.out.println();
        System.out.println("icflag - ignore case flag during diff/compare (true or false)");
        System.out.println();
        System.out.println("options: ");
        System.out.println("  --help    this messge ");
        System.out.println("  --verbose more info like EOF: line counts");
        System.out.println("  --debug   a large amount of debugging output");
        System.out.println();
        System.out.println("If a input, output or answer file is not needed/used use - (dash) for the name, for example:");
        System.out.println("java Validator - sumit.dat sumit.ans result.xml -pc2 1 true");
        System.out.println();
        System.out.println(vi.getSystemVersionInfo());
    }

    public static void main(String[] args) {
        Validator validator = new Validator();
        validator.runValidator(args);
    }

    void printUsage() {
        this.usage();
    }

    void requireFile(String filename, String descriptionForFile) {
        File file = new File(filename);
        if (!file.isFile()) {
            this.fatalError(descriptionForFile + " does not exist (" + filename + ")", 7);
        }
    }

    private void checkForOutputFile() {
        File checkFile = new File(this.outputFileName);
        if (!checkFile.isFile()) {
            this.extraValidatorDifference = "NO Team output file created - nothing to read ";
            try {
                this.writeResultFile(this.resultFileName, JUDGEMENT_NO_WRONG_ANSWER, this.extraValidatorDifference);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                this.fatalError("Trouble writing result file " + this.resultFileName, 4);
            }
        }
    }

    private String simpleDiff(BufferedReader outputFile, BufferedReader answerFile) throws IOException {
        int lineNo = 1;
        String outputLine = outputFile.readLine();
        String answerLine = answerFile.readLine();
        while (outputLine != null && answerLine != null) {
            if (this.debugFlag) {
                System.out.println();
                System.out.println("O " + lineNo + ": " + outputLine);
                System.out.println("A " + lineNo + ": " + answerLine);
            }
            if (this.ignoreCaseFlag) {
                if (!outputLine.equalsIgnoreCase(answerLine)) {
                    if (this.debugFlag) {
                        System.out.println("  " + lineNo + "! " + this.compareLine(outputLine, answerLine));
                    }
                    this.extraValidatorDifference = "Answer and output file different (ignore case) at line  " + lineNo;
                    return JUDGEMENT_NO_WRONG_ANSWER;
                }
            } else if (!outputLine.equals(answerLine)) {
                if (this.debugFlag) {
                    System.out.println("  " + lineNo + "! " + this.compareLine(outputLine, answerLine));
                }
                this.extraValidatorDifference = "Answer and output file different at line  " + lineNo;
                return JUDGEMENT_NO_WRONG_ANSWER;
            }
            answerLine = answerFile.readLine();
            outputLine = outputFile.readLine();
            ++lineNo;
        }
        if (outputLine != null && answerLine == null) {
            this.extraValidatorDifference = "Team's output file is longer than answer file, at line " + lineNo;
            return JUDGEMENT_NO_WRONG_ANSWER;
        }
        if (answerLine != null && outputLine == null) {
            this.extraValidatorDifference = "Team output file shorter than answer file, at line " + lineNo;
            return JUDGEMENT_NO_WRONG_ANSWER;
        }
        if (answerLine == null && this.verbose) {
            System.out.println("EOF: answer file " + lineNo + " lines.");
        }
        if (outputLine == null && this.verbose) {
            System.out.println("EOF: output file " + lineNo + " lines.");
        }
        return JUDGEMENT_YES;
    }

    private String complexDiff(BufferedReader outputFile, BufferedReader answerFile, boolean ignoreLeadingWhitespace, boolean ignoreBlankLines, boolean ignoreWhiteSpace) throws IOException {
        String answerLine;
        String outputLine;
        int lineNo = 1;
        if (ignoreLeadingWhitespace || ignoreBlankLines) {
            outputLine = this.readPastBlankLines(outputFile);
            answerLine = this.readPastBlankLines(answerFile);
        } else {
            answerLine = answerFile.readLine();
            outputLine = outputFile.readLine();
        }
        while (outputLine != null && answerLine != null) {
            if (this.debugFlag) {
                System.out.println();
                System.out.println("O " + lineNo + ": " + outputLine);
                System.out.println("A " + lineNo + ": " + answerLine);
            }
            if (ignoreWhiteSpace) {
                outputLine = this.stripWhiteSpace(outputLine);
                answerLine = this.stripWhiteSpace(answerLine);
            }
            if (this.debugFlag) {
                System.out.println("o " + lineNo + ": " + outputLine);
                System.out.println("a " + lineNo + ": " + answerLine);
            }
            if (this.ignoreCaseFlag) {
                if (!outputLine.equalsIgnoreCase(answerLine)) {
                    if (this.debugFlag) {
                        System.out.println("  " + lineNo + "! " + this.compareLine(outputLine, answerLine));
                    }
                    this.extraValidatorDifference = "Answer and output file different (ignore case) at line  " + lineNo;
                    return JUDGEMENT_NO_WRONG_ANSWER;
                }
            } else if (!outputLine.equals(answerLine)) {
                if (this.debugFlag) {
                    System.out.println("  " + lineNo + "! " + this.compareLine(outputLine, answerLine));
                }
                this.extraValidatorDifference = "Answer and output file different at line  " + lineNo;
                return JUDGEMENT_NO_WRONG_ANSWER;
            }
            if (ignoreBlankLines) {
                outputLine = this.readPastBlankLines(outputFile);
                answerLine = this.readPastBlankLines(answerFile);
            } else {
                answerLine = answerFile.readLine();
                outputLine = outputFile.readLine();
            }
            ++lineNo;
        }
        if (outputLine != null && answerLine == null) {
            this.extraValidatorDifference = "Team's output file is longer than answer file, at line " + lineNo;
            return JUDGEMENT_NO_WRONG_ANSWER;
        }
        if (answerLine != null && outputLine == null) {
            this.extraValidatorDifference = "Team output file shorter than answer file, at line " + lineNo;
            return JUDGEMENT_NO_WRONG_ANSWER;
        }
        if (answerLine == null && this.verbose) {
            System.out.println("EOF: answer file " + lineNo + " lines.");
        }
        if (outputLine == null && this.verbose) {
            System.out.println("EOF: output file " + lineNo + " lines.");
        }
        return JUDGEMENT_YES;
    }

    private String stripWhiteSpace(String outputLine) {
        String outline = outputLine.trim();
        StringBuffer buf = new StringBuffer();
        if (outline.length() == 0) {
            return outline;
        }
        for (int i = 0; i < outputLine.length(); ++i) {
            char ch = outputLine.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            buf.append(ch);
        }
        return new String(buf);
    }

    private String readPastBlankLines(BufferedReader buffReader) throws IOException {
        String line = buffReader.readLine();
        while (line != null && line.trim().length() == 0) {
            line = buffReader.readLine();
        }
        return line;
    }

    private String renderJudgement() throws IOException {
        boolean ignoreLeadingWhitespace = this.pc2Option.equals(IGNORE_WHITESPACE_HEAD);
        boolean ignoreWhiteSpace = this.pc2Option.equals(IGNORE_ALL_WHITESPACE);
        boolean ignoreEmptyLines = this.pc2Option.equals(IGNORE_EMPTY_LINES);
        boolean basicDiff = this.pc2Option.equals(REGULAR_DIFF);
        FileReader outputFileReader = new FileReader(this.outputFileName);
        BufferedReader outputFile = new BufferedReader(outputFileReader);
        FileReader answerFileReader = new FileReader(this.answerFileName);
        BufferedReader answerFile = new BufferedReader(answerFileReader);
        if (basicDiff) {
            return this.simpleDiff(outputFile, answerFile);
        }
        return this.complexDiff(outputFile, answerFile, ignoreLeadingWhitespace, ignoreEmptyLines, ignoreWhiteSpace);
    }

    private void fatalError(String message, int exitCode) {
        System.err.println("Error: " + message);
        if (this.allowFatalExit) {
            System.exit(exitCode);
        }
    }

    protected void writeResultFile(String filename, String judgement, String description) throws FileNotFoundException {
        if (this.debugFlag) {
            System.out.println();
            System.out.println("<result outcome =  \"" + judgement + "\" security = \"" + this.resultFileName + "\">" + description + "</result>");
        }
        PrintWriter fileWriter = new PrintWriter(new FileOutputStream(filename), true);
        fileWriter.println("<?xml version=\"1.0\"?>");
        fileWriter.println("<result outcome =  \"" + judgement + "\" security = \"" + this.resultFileName + "\">" + description + "</result>");
        fileWriter.close();
    }

    protected String compareLine(String line1, String line2) {
        int len1 = line1.length();
        int len2 = line2.length();
        int maxLength = Math.max(len1, len2);
        int minLength = Math.min(len1, len2);
        StringBuffer outbuf = new StringBuffer();
        for (int i = 0; i < maxLength; ++i) {
            int ch = 32;
            if (i < minLength) {
                if (line1.charAt(i) != line2.charAt(i)) {
                    ch = 94;
                }
            } else {
                ch = 94;
            }
            outbuf.append((char)ch);
        }
        return new String(outbuf);
    }

    public String[] loadFile(String filename) {
        Vector<String> lines = new Vector<String>();
        if (filename == null) {
            throw new IllegalArgumentException("filename is null");
        }
        try {
            if (!new File(filename).exists()) {
                return new String[0];
            }
            FileReader fileReader = new FileReader(filename);
            BufferedReader in = new BufferedReader(fileReader);
            String line = in.readLine();
            while (line != null) {
                lines.addElement(line);
                line = in.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (lines.size() == 0) {
            return new String[0];
        }
        String[] out = new String[lines.size()];
        for (int i = 0; i < lines.size(); ++i) {
            out[i] = (String)lines.elementAt(i);
        }
        return out;
    }

    public void runValidator(String[] args) {
        int argNum = 0;
        if (args.length == 0) {
            this.printUsage();
            if (this.allowFatalExit) {
                System.exit(0);
            }
        }
        if (args[argNum].equals("--help")) {
            this.printUsage();
            System.exit(4);
        }
        int numberOfArgs = args.length;
        if (args[argNum].equals("--nofatal")) {
            this.allowFatalExit = false;
            ++argNum;
            --numberOfArgs;
        }
        if (args[argNum].equals("--verbose")) {
            this.verbose = true;
            ++argNum;
            --numberOfArgs;
        }
        if (args[argNum].equals("--debug")) {
            this.debugFlag = true;
            ++argNum;
            --numberOfArgs;
        }
        if (numberOfArgs != 5 && numberOfArgs != 7) {
            this.fatalError("Too few paramaters, see usage", 6);
        }
        this.inputFileName = args[argNum++];
        this.outputFileName = args[argNum++];
        this.answerFileName = args[argNum++];
        this.resultFileName = args[argNum++];
        if (!this.inputFileName.equals("-")) {
            this.requireFile(this.inputFileName, "input file");
        }
        if (!this.outputFileName.equals("-")) {
            this.checkForOutputFile();
        }
        if (!this.answerFileName.equals("-")) {
            this.requireFile(this.answerFileName, "answer file");
        }
        if (this.resultFileName.equals("-")) {
            this.fatalError("Invalid result filename: -  is not allowed.", 7);
        }
        if (args[argNum].equalsIgnoreCase("-pc2")) {
            int n = ++argNum;
            ++argNum;
            this.pc2Option = args[n];
        }
        if (args[argNum].equalsIgnoreCase("true")) {
            this.ignoreCaseFlag = true;
        } else if (args[argNum].equalsIgnoreCase("false")) {
            this.ignoreCaseFlag = false;
        } else {
            this.fatalError("Invalid icflag expecting true or false, not: " + args[argNum], 8);
        }
        if (this.debugFlag) {
            System.out.println("Arguments: ");
            System.out.println("inputFileName = " + this.inputFileName);
            System.out.println("outputFileName = " + this.outputFileName);
            System.out.println("answerFileName = " + this.answerFileName);
            System.out.println("resultFileName = " + this.resultFileName);
            System.out.println("pc2Option = " + this.pc2Option);
            System.out.println("ignore case = " + this.ignoreCaseFlag);
            System.out.println();
        }
        String judgement = JUDGEMENT_NO_INDETERMINANT;
        try {
            judgement = this.renderJudgement();
        }
        catch (IOException e1) {
            System.err.println("Error reading output or answer file ");
            e1.printStackTrace(System.err);
        }
        try {
            this.writeResultFile(this.resultFileName, judgement, this.extraValidatorDifference);
        }
        catch (FileNotFoundException e) {
            System.out.println("Could not write result file" + this.resultFileName);
            e.printStackTrace();
        }
    }

    public String getInternalValidatorCommandLine(int whichCommand, boolean ignoreCase) {
        String javaCmd = "java edu.csus.ecs.pc2.validator.Validator";
        String commandLine = null;
        commandLine = javaCmd + " {:infile} {:outfile} {:ansfile} {:resfile} -pc2 " + whichCommand;
        commandLine = ignoreCase ? commandLine + " true" : commandLine + " false";
        return commandLine;
    }

    public boolean isAllowFatalExit() {
        return this.allowFatalExit;
    }

    public void setAllowFatalExit(boolean allowFatalExit) {
        this.allowFatalExit = allowFatalExit;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

