/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui.server;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IniFile;
import edu.csus.ecs.pc2.core.model.Profile;
import edu.csus.ecs.pc2.core.model.ProfileComparatorByName;
import edu.csus.ecs.pc2.core.security.FileSecurity;
import edu.csus.ecs.pc2.core.security.FileSecurityException;
import edu.csus.ecs.pc2.profile.ProfileLoadException;
import edu.csus.ecs.pc2.profile.ProfileManager;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.html.HTMLEditorKit;

public class StartupContestDialog
extends JDialog {
    private static final long serialVersionUID = -8322972123417494060L;
    private JPanel centerPane = null;
    private JPasswordField confirmPasswordTextField = null;
    private JPasswordField contestPasswordTextField = null;
    private JLabel nameTitleLabel = null;
    private JLabel versionTitleLabel = null;
    private JLabel passwordTitleLabel = null;
    private JButton loginButton = null;
    private JButton exitButton = null;
    private JLabel messageLabel = null;
    private JPanel mainPanel;
    private JPanel northPanel = null;
    private boolean bAlreadyLoggingIn = false;
    private JComboBox profilesComboBox = null;
    private JLabel profileTitleLabel = null;
    private int siteNumber = 1;
    private boolean showConfirmPassword = true;
    private JTextPane topTextPane = null;
    private JScrollPane descriptionScrollpane = null;
    private final String firstLoginText = "<html><center><font size=\"+1\"><b>The Contest Password</b><br>  In order to insure contest security,  all contest data is   protected by a master password. Before anyone can restart a   contest or access sensitive data they will be asked to enter   this contest master password.  This screen is the place where you set (and confirm) the value of the contest master password.   (Note that the contest master password is independent of the   passwords needed to login to any specific contest   account -- Server, Admin, Team, Judge, etc.)</font></center></html>";
    private final String subsequentLoginText = "<html><center><font size=\"+1\">This server has been started previously.  </font></center><font size=\"+1\"><br>To restart the server you must enter the Contest Master Password which was specified when the server was first started.<br></font></html>";

    public StartupContestDialog() {
        this.initialize();
        this.overRideLookAndFeel();
        this.setModal(true);
        FrameUtilities.centerFrame(this);
    }

    private void initialize() {
        this.setSize(new Dimension(532, 545));
        this.setPreferredSize(new Dimension(500, 430));
        this.setMinimumSize(new Dimension(500, 430));
        this.setBackground(new Color(253, 255, 255));
        this.setDefaultCloseOperation(0);
        this.setTitle("Set Contest Master Password");
        this.setContentPane(this.getMainPanel());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                StartupContestDialog.this.promptBeforeExit();
            }

            public void windowOpened(WindowEvent e) {
                super.windowOpened(e);
                StartupContestDialog.this.getContestPasswordTextField().requestFocus();
            }
        });
        VersionInfo versionInfo = new VersionInfo();
        this.versionTitleLabel.setText("PC^2 version " + versionInfo.getVersionNumber() + " " + versionInfo.getBuildNumber());
        this.populateProfileComboBox();
    }

    private void populateProfileComboBox() {
        this.getProfilesComboBox().removeAllItems();
        ProfileManager manager = new ProfileManager();
        int comboIndex = 0;
        if (manager.hasDefaultProfile()) {
            Profile[] profiles = new Profile[]{};
            try {
                profiles = manager.load();
                Profile currentProfile = manager.getDefaultProfile();
                if (!new File(currentProfile.getProfilePath()).isDirectory()) {
                    System.err.println("No such directory: " + currentProfile.getProfilePath());
                }
                Arrays.sort(profiles, new ProfileComparatorByName());
                int idx = 0;
                for (Profile profile : profiles) {
                    this.getProfilesComboBox().addItem(new ProfileWrapper(profile));
                    if (profile.getProfilePath().equals(currentProfile.getProfilePath())) {
                        comboIndex = idx;
                    }
                    ++idx;
                }
                String baseDirectoryName = this.getBaseProfileDirectoryName(currentProfile, "db." + this.getSiteNumber());
                String contestKeyFilename = baseDirectoryName + File.separator + FileSecurity.getContestKeyFileName();
                this.showConfirmPassword = !new File(contestKeyFilename).exists();
            }
            catch (IOException e) {
                this.fatalError("Unable to load profile list ", e);
            }
            catch (ProfileLoadException e) {
                this.fatalError("Unable to load profile list ", e);
            }
        } else {
            this.showConfirmPassword = true;
            Profile profile = ProfileManager.createNewProfile();
            this.getProfilesComboBox().addItem(new ProfileWrapper(profile));
        }
        this.getProfilesComboBox().setSelectedIndex(comboIndex);
        this.profileTitleLabel.setVisible(false);
        this.getProfilesComboBox().setVisible(false);
        this.getConfirmPasswordTextField().setVisible(this.showConfirmPassword);
        this.passwordTitleLabel.setVisible(this.showConfirmPassword);
        if (!this.showConfirmPassword) {
            this.topTextPane.setText("<html><center><font size=\"+1\">This server has been started previously.  </font></center><font size=\"+1\"><br>To restart the server you must enter the Contest Master Password which was specified when the server was first started.<br></font></html>");
            this.setTitle("Enter Contest Master Password");
        }
    }

    private void fatalError(String string, Exception e) {
        this.setStatusMessage(string + ", check logs");
        e.printStackTrace(System.err);
        System.exit(4);
    }

    private void overRideLookAndFeel() {
        String value = IniFile.getValue("client.plaf");
        if (value != null && value.equalsIgnoreCase("java")) {
            FrameUtilities.setJavaLookAndFeel();
        }
        if (value != null && value.equalsIgnoreCase("native")) {
            FrameUtilities.setNativeLookAndFeel();
        }
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new BorderLayout());
            this.mainPanel.add((Component)this.getPasswordTitleLabel(), "Center");
            this.mainPanel.add((Component)this.getNorthPanel(), "North");
        }
        return this.mainPanel;
    }

    private JPanel getPasswordTitleLabel() {
        if (this.centerPane == null) {
            this.profileTitleLabel = new JLabel();
            this.profileTitleLabel.setBounds(new Rectangle(53, 22, 105, 22));
            this.profileTitleLabel.setHorizontalAlignment(4);
            this.profileTitleLabel.setText("Profile");
            this.messageLabel = new JLabel();
            this.messageLabel.setForeground(Color.red);
            this.messageLabel.setText("");
            this.messageLabel.setFont(new Font("Dialog", 1, 14));
            this.messageLabel.setBounds(new Rectangle(50, 222, 393, 26));
            this.messageLabel.setHorizontalAlignment(0);
            this.passwordTitleLabel = new JLabel();
            this.passwordTitleLabel.setText("Confirm Contest Password");
            this.passwordTitleLabel.setBounds(new Rectangle(48, 128, 239, 16));
            this.versionTitleLabel = new JLabel();
            this.versionTitleLabel.setHorizontalAlignment(4);
            this.versionTitleLabel.setBounds(new Rectangle(116, 252, 306, 23));
            this.versionTitleLabel.setText("Version XX. XX YYYY vv 22");
            this.nameTitleLabel = new JLabel();
            this.nameTitleLabel.setText("Contest Password");
            this.nameTitleLabel.setLocation(new Point(48, 68));
            this.nameTitleLabel.setSize(new Dimension(150, 15));
            this.nameTitleLabel.setPreferredSize(new Dimension(45, 16));
            this.centerPane = new JPanel();
            this.centerPane.setLayout(null);
            this.centerPane.setBackground(Color.white);
            this.centerPane.add((Component)this.getConfirmPasswordTextField(), null);
            this.centerPane.add((Component)this.getContestPasswordTextField(), null);
            this.centerPane.add((Component)this.nameTitleLabel, null);
            this.centerPane.add((Component)this.versionTitleLabel, null);
            this.centerPane.add((Component)this.passwordTitleLabel, null);
            this.centerPane.add((Component)this.getLoginButton(), null);
            this.centerPane.add((Component)this.getExitButton(), null);
            this.centerPane.add((Component)this.messageLabel, null);
            this.centerPane.add((Component)this.getProfilesComboBox(), null);
            this.centerPane.add((Component)this.profileTitleLabel, null);
        }
        return this.centerPane;
    }

    private JPasswordField getConfirmPasswordTextField() {
        if (this.confirmPasswordTextField == null) {
            this.confirmPasswordTextField = new JPasswordField();
            this.confirmPasswordTextField.setBounds(new Rectangle(48, 146, 368, 20));
            this.confirmPasswordTextField.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        StartupContestDialog.this.attemptToLogin();
                    }
                }
            });
        }
        return this.confirmPasswordTextField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void attemptToLogin() {
        this.setStatusMessage("");
        if (this.getContestPassword() == null || this.getContestPassword().length() < 1) {
            this.setStatusMessage("Enter a contest password");
            return;
        }
        if (this.showConfirmPassword) {
            if (this.getConfirmPassword() == null || this.getConfirmPassword().length() < 1) {
                this.setStatusMessage("Enter a confirmation password");
                return;
            }
            if (!this.getContestPassword().equals(this.getConfirmPassword())) {
                this.setStatusMessage("Contest and Confirmation passwords do not match");
                return;
            }
        }
        if (this.bAlreadyLoggingIn) {
            return;
        }
        this.bAlreadyLoggingIn = true;
        try {
            if (!this.showConfirmPassword) {
                this.confirmContestPassword(this.getProfile(), this.getContestPassword());
                this.dispose();
            } else {
                this.dispose();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Incorrect contest password try again", 0);
        }
        finally {
            this.bAlreadyLoggingIn = false;
        }
    }

    private String getBaseProfileDirectoryName(Profile profile, String dirname) {
        if (profile != null) {
            return profile.getProfilePath() + File.separator + dirname;
        }
        return dirname;
    }

    private void confirmContestPassword(Profile selectedProfile, String contestPassword) throws Exception {
        String baseDirectoryName = this.getBaseProfileDirectoryName(selectedProfile, "db." + this.getSiteNumber());
        if (!new File(baseDirectoryName).isDirectory()) {
            throw new Exception("Missing profile db directory " + baseDirectoryName);
        }
        try {
            FileSecurity fileSecurity = new FileSecurity(baseDirectoryName);
            fileSecurity.verifyPassword(contestPassword.toCharArray());
            fileSecurity = null;
        }
        catch (FileSecurityException fileSecurityException) {
            if (fileSecurityException.getMessage().equals("FAILED_TO_DECRYPT")) {
                throw new Exception("Incorrect contest password, try again");
            }
            if (!fileSecurityException.getMessage().equals("KEY_FILE_NOT_FOUND")) {
                fileSecurityException.printStackTrace();
                throw new Exception("Trouble determining contest password (" + fileSecurityException.getMessage() + ")");
            }
        }
        catch (Exception e) {
            throw new Exception("Bad Trouble dude " + e.getLocalizedMessage());
        }
    }

    private JPasswordField getContestPasswordTextField() {
        if (this.contestPasswordTextField == null) {
            this.contestPasswordTextField = new JPasswordField();
            this.contestPasswordTextField.setBounds(new Rectangle(48, 84, 366, 20));
            this.contestPasswordTextField.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        if (StartupContestDialog.this.showConfirmPassword) {
                            StartupContestDialog.this.confirmPasswordTextField.requestFocus();
                        } else {
                            StartupContestDialog.this.attemptToLogin();
                        }
                    }
                }
            });
        }
        return this.contestPasswordTextField;
    }

    private JButton getLoginButton() {
        if (this.loginButton == null) {
            this.loginButton = new JButton();
            this.loginButton.setMnemonic(67);
            this.loginButton.setLocation(new Point(50, 180));
            this.loginButton.setSize(new Dimension(105, 26));
            this.loginButton.setText("Continue");
            this.loginButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    StartupContestDialog.this.messageLabel.setText("Logging in");
                    StartupContestDialog.this.attemptToLogin();
                }
            });
        }
        return this.loginButton;
    }

    private JButton getExitButton() {
        if (this.exitButton == null) {
            this.exitButton = new JButton();
            this.exitButton.setMnemonic(88);
            this.exitButton.setLocation(new Point(336, 181));
            this.exitButton.setSize(new Dimension(105, 26));
            this.exitButton.setText("Exit");
            this.exitButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    StartupContestDialog.this.promptBeforeExit();
                }
            });
        }
        return this.exitButton;
    }

    protected void promptBeforeExit() {
        this.setStatusMessage("");
        int result = FrameUtilities.yesNoCancelDialog(null, "Are you sure you want to exit?", "Exit PC^2");
        if (result == 0) {
            System.exit(0);
        }
    }

    private JPanel getNorthPanel() {
        if (this.northPanel == null) {
            this.northPanel = new JPanel();
            this.northPanel.setLayout(new BorderLayout());
            this.northPanel.setBackground(Color.white);
            this.northPanel.add((Component)this.getDescriptionScrollpane(), "North");
        }
        return this.northPanel;
    }

    private JComboBox getProfilesComboBox() {
        if (this.profilesComboBox == null) {
            this.profilesComboBox = new JComboBox();
            this.profilesComboBox.setBounds(new Rectangle(175, 21, 259, 25));
        }
        return this.profilesComboBox;
    }

    public void setStatusMessage(final String messageString) {
        Runnable messageRunnable = new Runnable(){

            public void run() {
                StartupContestDialog.this.messageLabel.setText(messageString);
            }
        };
        SwingUtilities.invokeLater(messageRunnable);
        FrameUtilities.regularCursor(this);
    }

    private String passwordTextFieldValue(JPasswordField field) {
        char[] fieldValue = field.getPassword();
        if (fieldValue.length == 0) {
            return null;
        }
        return new String(fieldValue);
    }

    public String getContestPassword() {
        return this.passwordTextFieldValue(this.contestPasswordTextField);
    }

    private String getConfirmPassword() {
        return this.passwordTextFieldValue(this.confirmPasswordTextField);
    }

    public void disableLoginButton() {
        this.getLoginButton().setEnabled(false);
    }

    public Profile getProfile() {
        ProfileWrapper wrapper = (ProfileWrapper)this.getProfilesComboBox().getSelectedItem();
        if (wrapper != null) {
            return wrapper.getProfile();
        }
        return null;
    }

    public int getSiteNumber() {
        return this.siteNumber;
    }

    public void setSiteNumber(int siteNumber) {
        this.siteNumber = siteNumber;
    }

    private JTextPane getTopTextPane() {
        if (this.topTextPane == null) {
            this.topTextPane = new JTextPane();
            this.topTextPane.setPreferredSize(new Dimension(6, 210));
            this.topTextPane.setEditorKit(new HTMLEditorKit());
            this.topTextPane.setText("<html><center><font size=\"+1\"><b>The Contest Password</b><br>  In order to insure contest security,  all contest data is   protected by a master password. Before anyone can restart a   contest or access sensitive data they will be asked to enter   this contest master password.  This screen is the place where you set (and confirm) the value of the contest master password.   (Note that the contest master password is independent of the   passwords needed to login to any specific contest   account -- Server, Admin, Team, Judge, etc.)</font></center></html>");
            this.topTextPane.setEditable(false);
        }
        return this.topTextPane;
    }

    private JScrollPane getDescriptionScrollpane() {
        if (this.descriptionScrollpane == null) {
            this.descriptionScrollpane = new JScrollPane();
            this.descriptionScrollpane.setViewportView(this.getTopTextPane());
        }
        return this.descriptionScrollpane;
    }

    protected class ProfileWrapper {
        private Profile profile;

        public ProfileWrapper(Profile profile) {
            this.profile = profile;
        }

        public Profile getProfile() {
            return this.profile;
        }

        public void setProfile(Profile profile) {
            this.profile = profile;
        }

        public String toString() {
            return this.profile.getName() + " (" + this.profile.getDescription() + ")";
        }
    }
}

