/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui.server;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.IniFile;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.AccountEvent;
import edu.csus.ecs.pc2.core.model.ContestTimeEvent;
import edu.csus.ecs.pc2.core.model.IAccountListener;
import edu.csus.ecs.pc2.core.model.IContestTimeListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.ILoginListener;
import edu.csus.ecs.pc2.core.model.IProfileListener;
import edu.csus.ecs.pc2.core.model.IRunListener;
import edu.csus.ecs.pc2.core.model.ISiteListener;
import edu.csus.ecs.pc2.core.model.LoginEvent;
import edu.csus.ecs.pc2.core.model.ProfileEvent;
import edu.csus.ecs.pc2.core.model.RunEvent;
import edu.csus.ecs.pc2.core.model.SiteEvent;
import edu.csus.ecs.pc2.plugin.ContestSummaryReports;
import edu.csus.ecs.pc2.ui.ConnectionsPane;
import edu.csus.ecs.pc2.ui.ContestTimesPane;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.LoadContestPane;
import edu.csus.ecs.pc2.ui.LogWindow;
import edu.csus.ecs.pc2.ui.LoginsPane;
import edu.csus.ecs.pc2.ui.MessageMonitorPane;
import edu.csus.ecs.pc2.ui.OptionsPanel;
import edu.csus.ecs.pc2.ui.PacketMonitorPane;
import edu.csus.ecs.pc2.ui.PlaybackPane;
import edu.csus.ecs.pc2.ui.PluginLoadPane;
import edu.csus.ecs.pc2.ui.ReportPane;
import edu.csus.ecs.pc2.ui.SitesPanel;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class ServerView
extends JFrame
implements UIPlugin {
    public static final String SVN_ID = "$Id: ServerView.java 2302 2011-07-20 16:29:32Z laned $";
    private IInternalContest model = null;
    private IInternalController controller = null;
    private static final long serialVersionUID = 4547574494017009634L;
    private JPanel mainViewPane = null;
    private JTabbedPane mainTabbedPane = null;
    private Log log = null;
    private JPanel messagePanel = null;
    private JLabel messageLabel = null;
    private JPanel exitPanel = null;
    private JButton exitButton = null;
    private LogWindow securityAlertLogWindow = null;
    private VersionInfo versionInfo = new VersionInfo();

    public ServerView() {
        this.initialize();
    }

    private void logDebugMessage(String message) {
        this.log.log(Log.DEBUG, message);
    }

    private void initialize() {
        this.setSize(new Dimension(580, 400));
        this.setDefaultCloseOperation(0);
        this.setTitle("Server View");
        this.setContentPane(this.getMainViewPane());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ServerView.this.promptAndExit();
            }
        });
        this.overRideLookAndFeel();
        FrameUtilities.centerFrameTop(this);
        this.setVisible(true);
        this.showMessage("Version " + this.versionInfo.getVersionNumber() + " (Build " + this.versionInfo.getBuildNumber() + ")");
    }

    private void overRideLookAndFeel() {
        String value = IniFile.getValue("server.plaf");
        if (value != null && value.equalsIgnoreCase("java")) {
            FrameUtilities.setJavaLookAndFeel();
        }
        if (value != null && value.equalsIgnoreCase("native")) {
            FrameUtilities.setNativeLookAndFeel();
        }
    }

    protected void promptAndExit() {
        int result = FrameUtilities.yesNoCancelDialog(null, "Are you sure you want to exit PC^2?", "Exit PC^2 Server Module");
        if (result == 0) {
            try {
                ContestSummaryReports contestReports = new ContestSummaryReports();
                contestReports.setContestAndController(this.model, this.controller);
                if (contestReports.isLateInContest()) {
                    contestReports.generateReports();
                    this.controller.getLog().info("Reports Generated to " + contestReports.getReportDirectory());
                }
            }
            catch (Exception e) {
                this.log.log(Log.WARNING, "Unable to create reports ", e);
            }
            this.log.info("Server " + this.model.getSiteNumber() + " halted");
            System.exit(0);
        }
    }

    private String accountText(Account account) {
        if (account == null) {
            return "null";
        }
        return account.getClientId().toString();
    }

    private JPanel getMainViewPane() {
        if (this.mainViewPane == null) {
            this.mainViewPane = new JPanel();
            this.mainViewPane.setLayout(new BorderLayout());
            this.mainViewPane.add((Component)this.getMainTabbedPane(), "Center");
            this.mainViewPane.add((Component)this.getMessagePanel(), "North");
        }
        return this.mainViewPane;
    }

    public void windowToRight(JFrame sourceFrame) {
        int rightX = sourceFrame.getX() + sourceFrame.getWidth();
        this.setLocation(rightX, this.getY());
    }

    private JTabbedPane getMainTabbedPane() {
        if (this.mainTabbedPane == null) {
            this.mainTabbedPane = new JTabbedPane();
        }
        return this.mainTabbedPane;
    }

    void updateFrameTitle(final boolean turnButtonsOn) {
        final ServerView thisFrame = this;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FrameUtilities.setFrameTitle(thisFrame, "Server (Site " + ServerView.this.model.getSiteNumber() + ")", turnButtonsOn, new VersionInfo());
            }
        });
    }

    protected void registerPlugin(UIPlugin plugin) {
        try {
            this.controller.register(plugin);
            plugin.setContestAndController(this.model, this.controller);
        }
        catch (Exception e) {
            this.controller.getLog().log(Log.WARNING, "Exception loading plugin ", e);
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error loading " + plugin.getPluginTitle());
        }
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.setModel(inContest);
        this.setController(inController);
        this.log = this.controller.getLog();
        this.populateUI();
        this.controller.startLogWindow(this.model);
        this.initializeSecurityAlertWindow(inContest);
        ServerListeners serverListeners = new ServerListeners();
        this.registerPlugin(serverListeners);
        ConnectionsPane connectionsPane = new ConnectionsPane();
        this.addUIPlugin(this.getMainTabbedPane(), "Connections", connectionsPane);
        if (Utilities.isDebugMode()) {
            try {
                LoadContestPane loadContestPane = new LoadContestPane();
                this.addUIPlugin(this.getMainTabbedPane(), "Load v8", loadContestPane);
            }
            catch (Exception e) {
                this.logException(e);
            }
        }
        LoginsPane loginsPane = new LoginsPane();
        this.addUIPlugin(this.getMainTabbedPane(), "Logins", loginsPane);
        if (Utilities.isDebugMode()) {
            try {
                MessageMonitorPane messageMonitorPane = new MessageMonitorPane();
                this.addUIPlugin(this.getMainTabbedPane(), "Messages", messageMonitorPane);
            }
            catch (Exception e) {
                this.logException(e);
            }
        }
        OptionsPanel optionsPanel = new OptionsPanel();
        this.addUIPlugin(this.getMainTabbedPane(), "Options", optionsPanel);
        optionsPanel.setSecurityLogWindow(this.securityAlertLogWindow);
        if (Utilities.isDebugMode()) {
            try {
                PacketMonitorPane packetMonitorPane = new PacketMonitorPane();
                this.addUIPlugin(this.getMainTabbedPane(), "Packets", packetMonitorPane);
            }
            catch (Exception e) {
                this.logException(e);
            }
        }
        if (Utilities.isDebugMode()) {
            try {
                PluginLoadPane pane = new PluginLoadPane();
                pane.setParentTabbedPane(this.getMainTabbedPane());
                this.addUIPlugin(this.getMainTabbedPane(), "Plugin Load", pane);
            }
            catch (Exception e) {
                this.logException(e);
            }
        }
        PlaybackPane playbackPane = new PlaybackPane();
        this.addUIPlugin(this.getMainTabbedPane(), "Replay", playbackPane);
        ReportPane reportPane = new ReportPane();
        this.addUIPlugin(this.getMainTabbedPane(), "Reports", reportPane);
        SitesPanel sitesPanel = new SitesPanel();
        this.addUIPlugin(this.getMainTabbedPane(), "Sites", sitesPanel);
        ContestTimesPane contestTimesPane = new ContestTimesPane();
        this.addUIPlugin(this.getMainTabbedPane(), "Times", contestTimesPane);
        this.setSelectedTab(this.getMainTabbedPane(), "Sites");
    }

    private void populateUI() {
        this.updateFrameTitle(this.model.getContestTime().isContestRunning());
        this.updateProfileLabel();
    }

    public void setModel(IInternalContest inContest) {
        this.model = inContest;
    }

    public void setController(IInternalController controller) {
        this.controller = controller;
    }

    protected void setSelectedTab(JTabbedPane tabbedPane, String name) {
        for (int i = 0; i < tabbedPane.getComponentCount(); ++i) {
            String tabTitle = tabbedPane.getTitleAt(i);
            if (tabTitle == null || !name.equals(tabTitle)) continue;
            tabbedPane.setSelectedIndex(i);
        }
    }

    private void logException(Exception e) {
        if (StaticLog.getLog() != null) {
            StaticLog.getLog().log(Log.WARNING, "Exception", e);
            e.printStackTrace(System.err);
        } else {
            e.printStackTrace(System.err);
        }
    }

    protected void initializeSecurityAlertWindow(IInternalContest inContest) {
        if (this.securityAlertLogWindow == null) {
            this.securityAlertLogWindow = new LogWindow(inContest.getSecurityAlertLog());
        }
        this.securityAlertLogWindow.setContestAndController(inContest, this.controller);
        this.securityAlertLogWindow.setTitle("Contest Security Alerts " + inContest.getClientId().toString());
        this.securityAlertLogWindow.getLog().info("Security Log Started " + this.versionInfo.getSystemVersionInfo());
    }

    public String getPluginTitle() {
        return "Server Main GUI";
    }

    protected void showLog(boolean showLogWindow) {
        this.controller.showLogWindow(showLogWindow);
    }

    protected void addUIPlugin(JTabbedPane tabbedPane, String tabTitle, JPanePlugin plugin) {
        try {
            plugin.setParentFrame(this);
            this.registerPlugin(plugin);
            tabbedPane.add((Component)plugin, tabTitle);
        }
        catch (Exception e) {
            this.controller.getLog().log(Log.WARNING, "Exception loading plugin ", e);
            JOptionPane.showMessageDialog(this, "Error loading " + plugin.getPluginTitle());
        }
    }

    protected void addUIPlugin(String tabTitle, JPanePlugin plugin) {
        try {
            plugin.setParentFrame(this);
            this.registerPlugin(plugin);
            this.getMainTabbedPane().add((Component)plugin, tabTitle);
        }
        catch (Exception e) {
            this.controller.getLog().log(Log.WARNING, "Exception loading plugin ", e);
            JOptionPane.showMessageDialog(this, "Error loading " + plugin.getPluginTitle());
        }
    }

    private JPanel getMessagePanel() {
        if (this.messagePanel == null) {
            BorderLayout borderLayout = new BorderLayout();
            borderLayout.setHgap(5);
            this.messageLabel = new JLabel();
            this.messageLabel.setText("");
            this.messageLabel.setFont(new Font("Dialog", 1, 14));
            this.messageLabel.setHorizontalAlignment(0);
            this.messageLabel.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() > 1) {
                        System.out.println("debug 22 profile is " + ServerView.this.model.getProfile().getName());
                        ServerView.this.updateProfileLabel();
                    }
                }
            });
            this.messagePanel = new JPanel();
            this.messagePanel.setLayout(borderLayout);
            this.messagePanel.setPreferredSize(new Dimension(40, 40));
            this.messagePanel.add((Component)this.messageLabel, "Center");
            this.messagePanel.add((Component)this.getExitPanel(), "East");
        }
        return this.messagePanel;
    }

    private JPanel getExitPanel() {
        if (this.exitPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(10);
            flowLayout.setVgap(5);
            this.exitPanel = new JPanel();
            this.exitPanel.setPreferredSize(new Dimension(75, 36));
            this.exitPanel.setLayout(flowLayout);
            this.exitPanel.add((Component)this.getExitButton(), null);
        }
        return this.exitPanel;
    }

    private JButton getExitButton() {
        if (this.exitButton == null) {
            this.exitButton = new JButton();
            this.exitButton.setText("Exit");
            this.exitButton.setMnemonic(88);
            this.exitButton.setToolTipText("Click here to Shutdown PC^2");
            this.exitButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ServerView.this.promptAndExit();
                }
            });
        }
        return this.exitButton;
    }

    private void showMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ServerView.this.messageLabel.setText(string);
            }
        });
    }

    private void updateProfileLabel() {
        int numberProfiles = this.model.getProfiles().length;
        String s = "";
        if (numberProfiles > 1) {
            s = "Active Profile is: \"" + this.model.getProfile().getName() + "\"";
        }
        final String message = s;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ServerView.this.messageLabel.setText(message);
                ServerView.this.messageLabel.setToolTipText("Version " + ServerView.this.versionInfo.getVersionNumber() + " (Build " + ServerView.this.versionInfo.getBuildNumber() + ")");
            }
        });
    }

    protected class ProfileListenerImplementation
    implements IProfileListener {
        protected ProfileListenerImplementation() {
        }

        public void profileAdded(ProfileEvent event) {
            ServerView.this.updateProfileLabel();
        }

        public void profileChanged(ProfileEvent event) {
            ServerView.this.updateProfileLabel();
        }

        public void profileRemoved(ProfileEvent event) {
        }

        public void profileRefreshAll(ProfileEvent profileEvent) {
            ServerView.this.updateProfileLabel();
        }
    }

    protected class ServerListeners
    implements UIPlugin {
        private static final long serialVersionUID = 3733076435840880891L;

        protected ServerListeners() {
        }

        public void setContestAndController(IInternalContest inContest, IInternalController inController) {
            inContest.addRunListener(new RunListenerImplementation());
            inContest.addAccountListener(new AccountListenerImplementation());
            inContest.addLoginListener(new LoginListenerImplementation());
            inContest.addSiteListener(new SiteListenerImplementation());
            inContest.addContestTimeListener(new ContestTimeListenerImplementation());
            inContest.addProfileListener(new ProfileListenerImplementation());
            ServerView.this.setModel(inContest);
            ServerView.this.setController(inController);
            ServerView.this.populateUI();
        }

        public String getPluginTitle() {
            return "ServerListeners";
        }
    }

    public class ContestTimeListenerImplementation
    implements IContestTimeListener {
        private int ignoreEvent = 0;

        public void contestTimeAdded(ContestTimeEvent event) {
            ++this.ignoreEvent;
        }

        public void contestTimeRemoved(ContestTimeEvent event) {
            ++this.ignoreEvent;
        }

        public void contestTimeChanged(ContestTimeEvent event) {
            ++this.ignoreEvent;
        }

        public void contestStarted(ContestTimeEvent event) {
            if (ServerView.this.model.getSiteNumber() == event.getSiteNumber()) {
                ServerView.this.updateFrameTitle(event.getContestTime().isContestRunning());
            }
        }

        public void contestStopped(ContestTimeEvent event) {
            if (ServerView.this.model.getSiteNumber() == event.getSiteNumber()) {
                ServerView.this.updateFrameTitle(event.getContestTime().isContestRunning());
            }
        }

        public void refreshAll(ContestTimeEvent event) {
            if (ServerView.this.model.getSiteNumber() == event.getSiteNumber()) {
                ServerView.this.updateFrameTitle(event.getContestTime().isContestRunning());
            }
        }
    }

    public class SiteListenerImplementation
    implements ISiteListener {
        public void siteProfileStatusChanged(SiteEvent event) {
        }

        public void siteAdded(SiteEvent event) {
            ServerView.this.logDebugMessage("Site Event Event " + (Object)((Object)event.getAction()) + " " + event.getSite());
        }

        public void siteRemoved(SiteEvent event) {
            ServerView.this.logDebugMessage("Site Event " + (Object)((Object)event.getAction()) + " " + event.getSite());
        }

        public void siteLoggedOn(SiteEvent event) {
            ServerView.this.logDebugMessage("Site Event " + (Object)((Object)event.getAction()) + " " + event.getSite());
        }

        public void siteLoggedOff(SiteEvent event) {
            ServerView.this.logDebugMessage("Site Event " + (Object)((Object)event.getAction()) + " " + event.getSite());
        }

        public void siteChanged(SiteEvent event) {
            ServerView.this.logDebugMessage("Site Event " + (Object)((Object)event.getAction()) + " " + event.getSite());
        }

        public void sitesRefreshAll(SiteEvent event) {
            ServerView.this.logDebugMessage("Site Event " + (Object)((Object)event.getAction()));
        }
    }

    public class AccountListenerImplementation
    implements IAccountListener {
        public void accountAdded(AccountEvent accountEvent) {
            ServerView.this.logDebugMessage("Account Event " + (Object)((Object)accountEvent.getAction()) + " " + ServerView.this.accountText(accountEvent.getAccount()));
        }

        public void accountModified(AccountEvent accountEvent) {
            ServerView.this.logDebugMessage("Account Event " + (Object)((Object)accountEvent.getAction()) + " " + ServerView.this.accountText(accountEvent.getAccount()));
        }

        public void accountsAdded(AccountEvent accountEvent) {
            ServerView.this.logDebugMessage("Account Event " + (Object)((Object)accountEvent.getAction()) + " " + accountEvent.getAccounts().length + " accounts");
        }

        public void accountsModified(AccountEvent accountEvent) {
            ServerView.this.logDebugMessage("Account Event " + (Object)((Object)accountEvent.getAction()) + " " + accountEvent.getAccounts().length + " accounts");
        }

        public void accountsRefreshAll(AccountEvent accountEvent) {
            ServerView.this.logDebugMessage("Account Event " + (Object)((Object)accountEvent.getAction()) + " " + accountEvent.getAccounts().length + " accounts");
        }
    }

    public class LoginListenerImplementation
    implements ILoginListener {
        public void loginAdded(LoginEvent event) {
            ServerView.this.logDebugMessage("Login Event " + (Object)((Object)event.getAction()) + " " + event.getClientId());
        }

        public void loginRemoved(LoginEvent event) {
            ServerView.this.logDebugMessage("Login Event " + (Object)((Object)event.getAction()) + " " + event.getClientId());
        }

        public void loginDenied(LoginEvent event) {
            ServerView.this.logDebugMessage("Login Event " + (Object)((Object)event.getAction()) + " " + event.getClientId());
        }

        public void loginRefreshAll(LoginEvent event) {
            ServerView.this.logDebugMessage("Login Event " + (Object)((Object)event.getAction()) + " " + event.getClientId());
        }
    }

    private class RunListenerImplementation
    implements IRunListener {
        private RunListenerImplementation() {
        }

        public void runAdded(RunEvent event) {
            ServerView.this.logDebugMessage("Run Event " + event.getRun() + " ADDED ");
        }

        public void refreshRuns(RunEvent event) {
            ServerView.this.logDebugMessage("Run Event " + event.getRun() + " REFRESH/RESET RUNS ");
        }

        public void runChanged(RunEvent event) {
            ServerView.this.logDebugMessage("Run Event " + event.getRun() + " CHANGED ");
        }

        public void runRemoved(RunEvent event) {
            ServerView.this.logDebugMessage("Run Event " + event.getRun() + " REMOVED ");
        }
    }
}

